'\" p
.TH @G@SOELIM @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
@g@soelim \- interpret .so requests in groff input
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr soelim_C \n[.C]
.cp 0
.mso pic.tmac
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2018 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY @g@soelim
.OP \-Crtv
.OP \-I dir
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.B @g@soelim
reads
.I files
and replaces lines of the form
.IP
.BI .so\~ file
.LP
by the contents of
.IR file .
.
It is useful if files included with
.B .so
need to be preprocessed.
.
Normally,
.B @g@soelim
should be invoked with the
.B \-s
option of
.BR groff .
.
.
.PP
To embed \[oq]\[rs]\[cq] in the file name, write \[oq]\[rs]\[rs]\[cq]
or \[oq]\[rs]e\[cq].
.
To embed a space, write \[oq]\[rs]\ \[cq].
.
Any other escape sequence in
.I file
makes
.B soelim
ignore the whole line.
.
.
.PP
Note that there must be no whitespace between the leading dot and the two
characters \[oq]s\[cq] and \[oq]o\[cq].
.
Otherwise, only
.B groff
interprets the
.B .so
request (and
.B soelim
ignores it).
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
Whitespace is permitted between a command-line option and its argument.
.
.
.TP
.B \-C
Recognize
.B .so
even when followed by a character other than space or newline.
.
.TP
.BI \-I dir
This option may be used to add a directory to the search path for
files (both those on the command line and those named in
.B .so
requests).
.
The search path is initialized with the current directory.
.
This option may be specified more than once; the directories are then
searched in the order specified (but before the current directory).
.
If you want to make the current directory be read before other
directories, add
.B \-I.\&
at the appropriate place.
.
.IP
No directory search is performed for files with an absolute file name.
.
.TP
.B \-r
Do not add
.B .lf
requests (for general use, with non-groff files).
.
.TP
.B \-t
Don't emit
.B .lf
requests but TeX comment lines (starting with \[oq]%\[cq]) giving the
current file and line number.
.
.TP
.B \-v
Print the version number.
.
.
.\" ====================================================================
.SH USAGE
.\" ====================================================================
.
The normal processing sequence of groff is this:
.
.
.PP
.ie t \{\
.PS
.ps 10
.vs 12
box invisible width 0.5 height 0.4 "input" "file";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.8 height 0.2 "preprocessor";
move to last box .right
right;
arrow 0.3;
A: box invisible width 0.35 height 0.2 "troff";
move to last box .top;
up;
move 0.3;
box invisible width 0.6 height 0.4 "sourced" "file";
line <- up 0.3 from A.top;
move to A.right;
right;
arrow 0.3;
box invisible width 0.85 height 0.2 "postprocessor";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.5 height 0.4 "output" "file"
.ps
.vs
.PE
.\}
.el \{\
.nf
          input        sourced
          file          file
            |             |
            v             v
        preprocessor -> troff -> postprocessor
                                      |
                                      v
                                   output
                                    file
.fi
.\}
.PP
.
That is, files sourced with
.B .so
are normally read
.I only
by
.B troff
(the actual formatter).
.
.B soelim
is
.I not
required for
.B troff
to source files.
.
.
.PP
If a file to be sourced should also be preprocessed, it must already be read
.I before
the input file passes through the preprocessor.
.
This is handled by
.BR soelim :
.
.PP
.ie t \{\
.PS
.ps 10
.vs 12
box invisible width 0.5 height 0.4 "input" "file";
move to last box .bottom;
down;
arrow 0.3;
A: box invisible width 0.5 height 0.2 "soelim";
line <- 0.3;
box invisible width 0.5 height 0.4 "sourced" "file";
move to A.right;
right;
arrow 0.3;
box invisible width 0.8 height 0.2 "preprocessor";
arrow 0.3;
box invisible width 0.35 height 0.2 "troff";
arrow 0.3
box invisible width 0.85 height 0.2 "postprocessor";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.5 height 0.4 "output" "file"
.ps
.vs
.PE
.\}
.el \{\
.nf
          input
          file
            |
            v
          soelim -> preprocessor -> troff -> postprocessor
            ^                                     |
            |                                     v
         sourced                               output
          file                                  file
.fi
.\}
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.BR groff (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[soelim_C]
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
