/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This class exists to separate error messages from the code that
 * raises them, so that generating error messages and raising exceptions
 * does not have to clutter other code.
 */

#import <Foundation/NSString.h>
#import <Foundation/NSException.h>

@interface GrouchException : NSObject

// Names of exceptions
+ (NSString*)memoryException;	// Same as NSMallocException
+ (NSString*)socketException;

// Convenient methods to raise exceptions
+ (void)raiseMemoryException;
+ (void)raiseSocketExceptionForHost:(NSString*)host withReason:(NSString*)why;

@end
