/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * A subclass of NSTextView that traps the return key and performs an
 * action.
 */

#import <ImTextView.h>
#import <AppKit/NSEvent.h>

@implementation ImTextView

- (void)keyDown:(NSEvent*)e
{
	if(!([e modifierFlags]&NSShiftKeyMask)&&[[e characters] isEqual:@"\r"])
	{
		if( _target && _action )
			[_target performSelector:_action withObject:self];
	}
	else
		[super keyDown:e];
}

- (void)setTarget:t
{
	_target = t;
}
- target
{
	return _target;
}
- (void)setAction:(SEL)sel
{
	_action = sel;
}
- (SEL)action
{
	return _action;
}

@end
