/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * The BOS service.  This is where most of the action is.
 * See OscarBos.m.
 */

#import <Oscar/OscarClient.h>
#import <Oscar/OscarBuffer.h>
#import <Grouch/GrouchClient.h>

@class OscarAuthCookie;
@class NSArray;

@interface OscarBos : OscarFlap
{
	NSString *profile, *away;
}

+ bosForHost:(NSString*)host withCredentials:(id<OscarCredentials>)creds
  andClient:(OscarClient*)cli;
- initForHost:(NSString*)host withCredentials:(id<OscarCredentials>)creds
  andClient:(OscarClient*)cli;

- init;
- (void)dealloc;

- (void)sendingCookie;

- (void)sendMessage:(NSString*)msg to:(NSString*)user
  withFlags:(GrouchMessageFlags)f;

- (void)addProfileString:(NSString*)str toBuffer:(OscarBuffer*)buf
	 withTLV:(int)tlv;
- (void)updateInfo;

- (void)profile:(NSString*)str;
- (void)away:(NSString*)str;
- (void)idle:(time_t)i;
- (void)getInfo:(id<GrouchProfile>)prof forUser:(NSString*)str
	withFlags:(int)flags;
- (void)getInfo:(id<GrouchProfile>)prof forUser:(NSString*)str;
- (void)getAwayMessage:(id<GrouchProfile>)prof forUser:(NSString*)str;

- (void)askForChatNav;
- (void)askForChannel:(NSString*)channel withCookie:(NSString*)cookie
	 andExchange:(int)ex andInstance:(int)inst;

// Buddy list interaction
- (void)addSsiRecords:(NSArray*)records;
- (void)updateSsiRecords:(NSArray*)array;
- (void)removeSsiRecords:(NSArray*)records;

- (void)welcome;
- (void)connectionClosed:sock;

@end

