/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * TODO: make the options actually do 
 * Non-functional.  Very much a work in progress.
 */

#import <Defaults.h>
#import <Prefs.h>
#import <AppKit/AppKit.h>
#import <Renaissance/Renaissance.h>
#import <Renaissance/GNUstep.h>

enum
{
	IncomingMsg	= 0,
	OutgoingMsg	= 1,
	IncomingChatMsg = 2,
	OutgoingChatMsg = 3,
	SignOn		= 0,
	SignOff		= 1
};

@implementation PrefsEvents

- (NSView*)create
{
	[NSBundle loadGSMarkupNamed:@"PrefsEvents" owner:self];

	[msgBox release];
	[listBox release];
	[msgEvent release];
	[listEvent release];
	[msgFlagF release];
	[msgFlagB release];
	[msgSoundSwitch release];
	[listFlagF release];
	[listFlagB release];
	[listSoundSwitch release];
	[msgSound release];
	[listSound release];
	[root autorelease];

	[msgEvent selectItemAtIndex:IncomingMsg];
	[listEvent selectItemAtIndex:SignOn];

	[self load];

	[self switchMsgEvent:nil];
	[self switchListEvent:nil];

	return root;
}

- (NSButton*)button
{
	NSButton *r = [[NSButton alloc] initWithFrame:NSMakeRect(0,0,0,0)];
	[r setTitle:_(@"Sounds & Events")];
	return [r autorelease];
}

- (void)load
{
	NSDictionary *dict = [Defaults get:@"Events"];
	NSEnumerator *e;
	NSObject *k;

	if(!dict)
		dict = [NSDictionary dictionary];
	events = [[NSMutableDictionary dictionaryWithDictionary:dict] retain];

	e = [dict keyEnumerator]; 
	while((k=[e nextObject]))
	{
		NSDictionary *o = [dict objectForKey:k];
		if([o isKindOfClass:[NSDictionary class]])
		{
			o = [NSMutableDictionary dictionaryWithDictionary:o];
			[events setObject:o forKey:k];
		}
	}

	currentMsgEvent = currentListEvent = nil;
}

- (void)save
{
	[self checkMsgEvent:nil];
	[self checkListEvent:nil];
	[Defaults set:events forKey:@"Events"];
}

- (void)switchMsgEvent:sender
{
	NSString *key = nil;
	[self checkMsgEvent:nil];
	switch([msgEvent indexOfSelectedItem])
	{
	case IncomingMsg:
		key = @"in";
		break;
	case OutgoingMsg:
		key = @"out";
		break;
	case IncomingChatMsg:
		key = @"chat in";
		break;
	case OutgoingChatMsg:
		key = @"chat out";
	}
	if(key)
	{
		NSString *flags;
		currentMsgEvent = [events objectForKey:key];
		if(!currentMsgEvent)
		{
			currentMsgEvent = [NSMutableDictionary dictionary];
			[events setObject:currentMsgEvent forKey:key];
		}
		flags = [currentMsgEvent objectForKey:@"Flags"];
		if(!flags)
			flags = @"";
		[msgFlagF setState:[flags rangeOfString:@"f"].length ?
			  NSOnState : NSOffState];
		[msgFlagB setState:[flags rangeOfString:@"b"].length ?
			  NSOnState : NSOffState];
	}
}

- (void)switchListEvent:sender
{
	NSString *key = nil;
	[self checkListEvent:nil];
	switch([listEvent indexOfSelectedItem])
	{
	case SignOn:
		key = @"on";
		break;
	case SignOff:
		key = @"off";
	}
	if(key)
	{
		NSString *flags;
		currentListEvent = [events objectForKey:key];
		if(!currentListEvent)
		{
			currentListEvent = [NSMutableDictionary dictionary];
			[events setObject:currentListEvent forKey:key];
		}
		flags = [currentListEvent objectForKey:@"Flags"];
		if(!flags)
			flags = @"";
		[listFlagB setState:[flags rangeOfString:@"b"].length ?
			  NSOnState : NSOffState];
	}
}

- (void)checkMsgEvent:sender
{
	NSString *f = @"", *b = @"";
	if(!currentMsgEvent)
		return;
	if([msgFlagF state] == NSOnState)
		f = @"f";
	if([msgFlagB state] == NSOnState)
		b = @"b";
	[currentMsgEvent setObject:[NSString stringWithFormat:@"%@%@",f,b]
			 forKey:@"Flags"];
}

- (void)checkListEvent:sender
{
	NSString *b = @"";
	if(!currentListEvent)
		return;
	if([listFlagB state] == NSOnState)
		b = @"b";
	[currentListEvent setObject:[NSString stringWithFormat:@"%@",b]
			 forKey:@"Flags"];
}

@end

