#!/bin/sh
#
# Copy a framework on Mac OS X
#
# usage: copy-framework.sh Framework destdir
# where Framework is the name, without extension, e.g. "Renaissance"

main() {
	[ -d "$2/$1.framework" ] || \
	framework_paths | while read path; do
		framework="$path/$1.framework"
		if [ -d "$framework" ]; then
			mkdir -p "$2"
			cp -R "$framework" "$2"
			exit $?
		fi
	done
}

## Support functions
# Outputs framework paths, one per line
framework_paths() {
	echo /Library/Frameworks
	echo /System/Library/Frameworks
	[ -d ~/Library/Frameworks ] && echo ~/Library/Frameworks
	[ x"$DYLD_FRAMEWORK_PATH" != x ] && local_framework_paths
}
local_framework_paths() {
	frameworks="$DYLD_FRAMEWORK_PATH"
	while [ x"`echo $frameworks|grep ':'`" != x ]; do
		echo $frameworks | cut -d : -f 1
		frameworks="`echo $frameworks | cut -d : -f 2-`"
	done
	[ x"$frameworks" != x ] && echo $frameworks
}

main "$@"
