
/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/* Project: GRUB
 * <http://www.grub.org>
 * module: CSTAT
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 18 Apr, 2001
 * Files: GrubCLog.h GrubCLog.cpp gc_log.cpp gc_log.h
 *
 *
 */


//***********************************************************
#ifndef _GrubCLog_H_
#define _GrubCLog_H_

#include <stdarg.h>
#include "gc_log.h"

//Maximum length of each of the log files
#define MAX_FILE_LEN 10000000
//Maximum log message length
#define MAX_MSG_LEN 3056

class GrubCLog
{
  public:
  	/*
  	GrubCLog(char *fname, bool print_to_stdout, unsigned int level);
  	
  	fname -- filename of first log file. Subsequent ones concatenate
  		the current time in their name
  	print_to_stdout -- true or false if we print to stdout or only to file
  	level -- one of the GC_LOG constants defined in "gc_log.h". It takes
  	 	that level and logs it and all above it
  	*/
  	GrubCLog(char *fname, bool print_to_stdout, unsigned int level);
  	
  	~GrubCLog();
  	
  	/*
  	Logprintf(unsigned int level, char *information, ...);
  	
  	Similar to printf but includes an error level with the message.
  	
  	*/
   	int Logprintf(unsigned int level, char *information, ...);
   	
  private:
        GC_Log *mylog;


};

extern GrubCLog *client_log;
extern GrubCLog *gui_log;

#endif
