/* Project: GRUB http://www.grub.org
 * moduel: CSTAT
 * purpose: gc_log file name operators 
 * Ben Guofu Wu bante@mailandnews.com
 * Last revsion: 15 August 2000
 * Files: filename.h 
 * See also: gc_log.h, gc_log_test.cpp, gc_thread_test.cpp, Thread.t.cpp
 *
 *  
 * This module is only tested on linuxPPC1999 at the moment. 
 *
 */

#ifndef FILENAME_H
#define FILENAME_H
#define DEFAULT_LOG_FILE_NAME "grubc_log"
#define PATH_DELIMITOR "/"
#include <string>
#include <list>

/* this class bases on the assumption that the log file names are in the format
 * of default_path+DEFAULT_LOG_FILE_NAME+rawtime+.log. If this is changed we
have to get the  * time the log file was last written to by Grub client (not
by the operator,  * who may want to change a log file by hand). The time can
be obtained in the  * last record of the log file. But it makes things much
easy to fix the log  * file name format. By this way we know which file is a
grub client file easily  * as well.
 */
class filename
{
	public:
		filename(const char *fn)
		{
		name = fn;
		//get the file name from the path+filename (the last occurance of the path
		//delimitor)
		std::string tmp = name; //copy construct
		int pos=0;
		while((pos = tmp.find(PATH_DELIMITOR)) < tmp.length())
			tmp = tmp.substr(pos+1, tmp.length()-pos-1);
		time = tmp.substr(sizeof(DEFAULT_LOG_FILE_NAME)-1,
		name.length()-sizeof(".log")-sizeof(DEFAULT_LOG_FILE_NAME) +2);		
		}
		std::string name;
		//use a string store the raw time
		std::string time;
		bool operator< (filename afile)
		{
			//compare the length
			if(time.length() == afile.time.length())
			{
				return time < afile.time;
			}
			else if(time.length()<afile.time.length()) return true;
			else return false;
		}
};
				


#endif
