#ifndef _Face_H_
#define _Face_H_

#include "Msg.h"
#include <map>
#include <string>

using std::string;
using std::map;
using std::pair;

typedef map<std::string, int> EventMap;
typedef EventMap::iterator EventMapIter;

// TODOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
// undefine DEBUG_FACE
#define DEBUG_FACE


#ifdef DEBUG_FACE
#include <cstdio>
#	define PRINT_ENTRY(type, name) \
		do { \
			printf("ENTERING %s %s\n", type, name); \
		} while (0)
#else
#	define PRINT_ENTRY(type, name) \
		do { \
		} while (0)
#endif

#define ENTER_FACE_POST(name) \
	do { \
		if ( !IsConnected() ) return; \
		lock(); \
		PRINT_ENTRY("Post", #name ); \
		messenger->setMessageType("Post"); \
		messenger->setMessageName( #name ); \
	} while (0)
#define ENTER_FACE_RING(name) \
	do { \
		if ( !IsConnected() ) return; \
		lock(); \
		PRINT_ENTRY("Ring", #name ); \
		messenger->setMessageType("Ring"); \
		messenger->setMessageName( #name ); \
	} while (0)
#define ENTER_FACE_EVENT(name) \
	do { \
		PRINT_ENTRY("Event", #name ); \
	} while (0)

#define EXIT_FACE_POST() \
	do { \
		messenger->send(); \
		unlock(); \
	} while (0)
#define EXIT_FACE_RING() \
	do { \
		messenger->send(); \
		unlock(); \
	} while (0)
#define EXIT_FACE_EVENT() \
	do { \
	} while (0)


#define EVENT_ID(event_name) EVID_##event_name

#define DEFINE_FACE_EVENT(event_name) \
	int EVENT_ID(event_name)

#define ADD_FACE_EVENT(event_name) \
	do { \
		EVENT_ID(event_name) = event_map_count; \
		event_map.insert( \
			pair<std::string, int>( #event_name, event_map_count ) ); \
		event_map_count++; \
	} while (0)

#define BEGIN_FIRE_EVENTS \
	int event_id; \
	if ( !msg ) event_id = -1; \
	else { \
		if ( messenger->setMessage(msg) == 0 ) { \
			char *name; \
			if ( messenger->getMessageName(name) ) { \
				EventMapIter iter = event_map.find(name); \
				if ( iter != event_map.end() ) \
					event_id = iter->second; \
				else \
					event_id = -2; \
			} \
			else \
				event_id = -2; \
		} \
		else \
			event_id = -1; \
	} \
	if (0) { }

#define END_FIRE_EVENTS

#define BEGIN_FIRE(event_type) \
	else if ( event_id == EVENT_ID(event_type) ) { \
		int _fret_;

#define END_FIRE \
	} /* end else if */

#define BEGIN_FIRE_BADPARSE \
	if ( event_id == -1 ) { \
		messenger->invokeError( \
			"XML parser error: Bad XML" \
		);

#define END_FIRE_BADPARSE \
	} /* end else if */

#define BEGIN_FIRE_INVALIDMSG \
	fire_invalid_msg: \
	if ( event_id == -2 ) { \
		messenger->invokeError( \
			"Unknown or invalid message event was received" \
		);

#define END_FIRE_INVALIDMSG \
	}

#define APPEND_INTEGER(field) \
	do { \
		messenger->appendDataInteger( #field, field ); \
	} while (0)

#define APPEND_DOUBLE(field) \
	do { \
		messenger->appendDataDouble( #field, field ); \
	} while (0)

#define APPEND_STRING(field) \
	do { \
		messenger->appendDataString( #field, field ); \
	} while (0)

#define GET_INTEGER(field) \
	int field; \
	_fret_ = messenger->getDataInteger( #field, 0, field ); \
	if ( _fret_ != 1 ) goto fire_invalid_msg;

#define GET_DOUBLE(field) \
	double field; \
	_fret_ = messenger->getDataDouble( #field, 0, field ); \
	if ( _fret_ != 1 ) goto fire_invalid_msg;

#define GET_STRING(field) \
	char *field; \
	_fret_ = messenger->getDataString( #field, 0, field ); \
	if ( _fret_ != 1 ) goto fire_invalid_msg;


class Face;

class MsgManagerX : public MsgManager {
public:
	MsgManagerX( unsigned short portnum );
	MsgManagerX( unsigned short portnum, const char *hostname );
	virtual ~MsgManagerX();

	inline void setFace( Face *face ) { this->face = face; }

	virtual void readCallback( const char *data );
	virtual void errorCallback( const char *msg );

private:
	Face *face;
};


class Face {
protected:
	Face();
	virtual ~Face();

	void connectServer( unsigned short portnum );
	void connectClient( const char *hostname, unsigned short portnum );
	void refresh();
	void disconnect();
	bool isConnected();
	bool isActive();

	virtual void readCallback( const char *data ) = 0;
	virtual void errorCallback( const char *msg ) = 0;

	// util stuff
	void lock();
	void unlock();
	char *strcopy( const char *str );

	MutexType mutex;
	MsgManagerX *messenger;

	EventMap event_map;
	int event_map_count;

	friend class MsgManagerX;
};

#endif  /* _Face_H_ */
