/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/ 
/* Project: GRUB 
 * <http://www.grub.org>
 * module: CREQ
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 13 March, 2001
 * Files: GetParser.cpp GetParser.h
 *
 * Class used to parse the REQUEST or GET part of the protocol. 
 * The class GetProtocol extends the methods getNewURL and getOldURL
 * to perform insertion to the DB or other functionality. This 
 * class invokes these methods after it has parsed out each URL
 * See the protocol documentation for more details.
 */

//***********************************************************
#ifndef _GetParser_H_
#define _GetParser_H_

#include <stdio.h>
#include <string>
#include <Communication.h>
#include "Parser.h"

/*Maximum length of a word from the input */
#define MAX_LINE_LENGTH 1000

class GetParser : public Parser
{
  public:
  	GetParser(Communication *);
  	virtual void getNewURL(string ,unsigned long ,unsigned long );
        virtual void getOldURL(string );
        void parse() throw (ParseExp);
	int getURLCount();
  private:
	/*
	int recv(string [])
	
	A wraparound funtion used to recieve data from the connection with the server.
	*/
  	int recv(string []);
        	
        Communication *comm; 
	int url_count;
};

#endif
