#include "GrubExp.h"

using namespace std;

GrubExp::GrubExp() throw() : msg(0)
{
	copy("Archive database exception");
}

GrubExp::GrubExp( const char * str ) throw() : msg(0)
{
	copy( str );
}

GrubExp::GrubExp( const GrubExp& exp )
	throw() : exception( exp ), msg(0)
{
	copy( exp.msg );
}

GrubExp::~GrubExp() throw()
{
	if ( msg )
		delete [] msg;
}

const char *GrubExp::what() throw()
{
	return msg;
}

GrubExp& GrubExp::operator=( const GrubExp& exp )
	throw()
{
	if ( this != &exp ) {

		copy( exp.msg );
	}

	return *this;
}

// CLASS GrubExp - PRIVATE

void GrubExp::copy( const char * str )
{
	if ( msg ) {

		delete [] msg;
		msg = 0;
	}

	if ( str ) {

		msg = new char[strlen(str) + 1];
		strcpy( msg, str );
	}
}

