//*****************************************************************************
//                                 CmdBase.cpp                                *
//                                -------------                               *
//  Started     : 31/08/2006                                                  *
//  Last Update : 30/01/2008                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/CmdBase.hpp"

//*****************************************************************************
// Constructor.

CmdBase::CmdBase( void ) : wxString( wxT("") )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdBase::~CmdBase( )
{
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  CmdBase::bClear( void )
{
  m_bIsOk = FALSE;

  wxString::Empty( );

  m_osName.Empty( );

  return( TRUE );
}

//*****************************************************************************
// Print the object attributes.
//
// Argument List :
//   psPrefix - A prefix to every line displayed (usually just spaces)

void  CmdBase::Print( const char * psPrefix )
{
  cout << psPrefix << "Command str  : " << this->mb_str( ) << '\n';
  cout << psPrefix << "m_bIsOk      : " << ( m_bIsOk ? "TRUE" : "FALSE" ) << '\n';
  cout << psPrefix << "m_osName     : " << m_osName.mb_str( ) << '\n';
}

//*****************************************************************************
