/* GStreamer
 *
 * v4lradio_calls.h: header for generic V4L calls
 *
 * Copyright (C) 2001-2002 Ronald Bultje <rbultje@ronald.bitfreak.net>
 * Copyright (C) 2005 Nickolay V. Shmyrev <nshmyrev@yandex.ru>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __V4LRADIO_CALLS_H__
#define __V4LRADIO_CALLS_H__

#include "gstv4lradiobin.h"
#include "gst/gst-i18n-plugin.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* simple check whether the device is open */
#define GST_V4LRADIO_IS_OPEN(element) \
  (element->radio_fd > 0)

/* checks whether the current v4lradio_bin has already been open()'ed or not */
#define GST_V4LRADIO_CHECK_OPEN(element)				\
  if (element->radio_fd <= 0)					\
  {								\
    GST_ELEMENT_ERROR (element, RESOURCE, TOO_LAZY,		\
      (_("Device is not open.")), (NULL));			\
    return FALSE;						\
  }

/* checks whether the current v4lradio_bin is close()'ed or whether it is still open */
#define GST_V4LRADIO_CHECK_NOT_OPEN(element)				\
  if (element->radio_fd != -1)					\
  {								\
    GST_ELEMENT_ERROR (element, RESOURCE, TOO_LAZY,		\
      (_("Device is open.")), (NULL));				\
    return FALSE;						\
  }


typedef enum {
  V4LRADIO_AUDIO_VOLUME = 0,
  V4LRADIO_AUDIO_MUTE,
  V4LRADIO_AUDIO_MODE, /* stereo, mono, ... (see videodev.h) */
} GstV4lRadioAudioType;


/* open/close the device */
gboolean gst_v4lradio_open           (GstV4lRadioBin *v4lradio_bin);
gboolean gst_v4lradio_close          (GstV4lRadioBin *v4lradio_bin);

/* frequency control */
gboolean gst_v4lradio_get_signal     (GstV4lRadioBin *v4lradio_bin,
				 guint         *signal);
gboolean gst_v4lradio_get_frequency  (GstV4lRadioBin *v4lradio_bin,
				 gulong        *frequency);
gboolean gst_v4lradio_set_frequency  (GstV4lRadioBin *v4lradio_bin,
				 gulong         frequency);

/* audio control */
gboolean gst_v4lradio_get_audio      (GstV4lRadioBin *v4lradio_bin,
				 GstV4lRadioAudioType type,
				 gint          *value);
gboolean gst_v4lradio_set_audio      (GstV4lRadioBin *v4lradio_bin,
				 GstV4lRadioAudioType type,
				 gint           value);
				 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __V4LRADIO_CALLS_H__ */
