/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include "gthumb-init.h"
#include "image-viewer.h"
#include "iids.h"
#include "viewer-control.h"


static BonoboGenericFactory *factory = NULL;
static gint active_controls = 0;


static void
control_destroy_cb (BonoboControl * control, 
		    gpointer callback_data)
{
        bonobo_object_unref (BONOBO_OBJECT (callback_data));
	active_controls--;

        if (active_controls > 0)
		return;

	gthumb_release ();
	bonobo_object_unref (BONOBO_OBJECT (factory));
	gtk_main_quit ();
}


static BonoboObject *
control_factory (BonoboGenericFactory *factory, 
		 gpointer callback_data)
{
	BonoboControl *control;
	GtkWidget *viewer;

	viewer = image_viewer_new ();
	control = viewer_control_new (IMAGE_VIEWER (viewer));

	if (!control) {
		gtk_object_destroy (GTK_OBJECT (viewer));
		return NULL;
	}

	gtk_signal_connect (GTK_OBJECT (viewer), 
			    "destroy",
                            control_destroy_cb, 
			    control);

	active_controls++;

	return BONOBO_OBJECT (control);
}


int 
main (int argc, char **argv)
{
	CORBA_ORB orb;

	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);

	gnome_init_with_popt_table ("gthumb-image-viewer", VERSION, argc,
				    argv, oaf_popt_options, 0, NULL);
	orb = oaf_init (argc, argv);

	if (! bonobo_init (orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL))
		g_error ("Could not initialize Bonobo");

	g_thread_init (NULL); 

	if (! gnome_vfs_init ()) 
		g_error ("Could not initialize the Virtual File System.");

	gdk_rgb_init ();
	gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
        gtk_widget_set_default_visual   (gdk_rgb_get_visual ());

	factory = bonobo_generic_factory_new (OAFIID_FACTORY, 
					      control_factory, 
					      NULL);

	if (factory == NULL)
		g_error ("Could not register the GNOME_GThumb_Viewer factory");

	gthumb_init ();

	bonobo_main ();

	return 0;
}
