/* Gtick  -  A Gtk+ Metronome
 *
 * Copyright (c) 1999, Alex Roberts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#ifndef __GTICK_H__
#define __GTICK_H__

#include <gtk/gtk.h>

#define TITLE		"gTick "VERSION

typedef struct _tiktok {
	GtkWidget *window;
	GtkWidget *box1;
  	GtkWidget *box2;
  	GtkWidget *box3;
  	GtkWidget *box4;
  	
  	GtkWidget *btn0;
  	GtkWidget *btn24;
  	GtkWidget *btn34;
  	GtkWidget *btn44;
  	
  	GtkWidget *button;
  	GtkWidget *togglebtn;
  	GtkWidget *scale;
  	GtkWidget *separator;
  	GtkObject *adjustment, *vAdj;
  	GtkWidget *vol;
  	
  	GtkWidget *label;
  	
  	GtkWidget *menubar;
  	GtkWidget *menu;
  	GtkWidget *menuitem;
  	
  	gboolean ticking;
  	gint count;
  	
} TikTok;

extern TikTok	*Metronome;

int gtInitDSP();
void gtCloseDSP();
void gtDSPTick(gint count);

void gtInitMixer();
void gtCloseMixer();
gint gtGetMixer();
void gtSetMixer(gint vol);

void gtAboutBox ();

#endif /* __GTICK_H__ */
