#ifndef PACKET_MAKER_H
#define PACKET_MAKER_H

#include <wibble/sys/buffer.h>
#include "NetSender.h"
#include "nettypes.h"

class PacketMaker
{
protected:
	NetSender& sender;
	
public:
	PacketMaker(NetSender& sender) : sender(sender) {}
	
	wibble::sys::Buffer makeARPRequest(const IPAddress& ip, const IPAddress& src) throw ();
	wibble::sys::Buffer makeARPRequest(const ether_addr& mac, const IPAddress& src) throw ();
	wibble::sys::Buffer makePingRequest(const ether_addr& mac, const IPAddress& src) throw ();
	wibble::sys::Buffer makeDHCPRequest() throw ();
};

// vim:set ts=4 sw=4:
#endif
