#include "ScanBag.h"
#include <iostream>

using namespace std;

void ScanBag::add(const Scan* scan) throw ()
{
	iterator i = find(scan->name());

	if (i == end())
	{
		if (const DefaultScan* s = dynamic_cast<const DefaultScan*>(scan))
		{
			//insert(pair<string, set<string> >(scan->name(), set<string>()));
			defaultProfile = s->name();
		} else {
			set<string> v;
			v.insert(scan->signature());
			insert(pair<string, set<string> >(scan->name(), v));
		}
	}
	else
	{
		i->second.insert(scan->signature());
	}

	scans.push_back(scan);
}

vector<string> ScanBag::notify(const Scan* scan) throw ()
{
	// The candidate winnowing algorithm:
	// For every candidate profile: if the profile has the scan
	// with the signature of "scan" then remove that scan;
	// otherwise remove the candidate.
	// Return the list of candidates left.

	//defaultProfile = "";
	
	vector<string> cands_left;
	string sig = scan->signature();
	for (iterator i = begin(); i != end(); )
	{
		set<string>::iterator j = i->second.find(sig);
		if (j == i->second.end())
		{
			// This candidate has no scan with the signature
			// so remove the candidate
			iterator k = i;
			k++;
			erase(i);
			i=k;
		}
		else
		{
			// This candidate has a scan with the signature
			// so remove the matching scan
			i->second.erase(j);
			cands_left.push_back(i->first);
			i++;
		}
	}
	return cands_left;
}

string ScanBag::getLessSpecific() const throw ()
{
	string cand;
	int count = -1;
	for (const_iterator i = begin(); i != end(); i++)
	{
		if (count == -1 || (signed)i->second.size() < count)
		{
			count = i->second.size();
			cand = i->first;
		}
	}
	return cand;
}

string ScanBag::getDefault() const throw ()
{
		return defaultProfile;
}

void ScanBag::dump() const throw ()
{
	for (const_iterator i = begin(); i != end(); i++)
	{
		cout << i->first << ": ";
		for (set<string>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
			if (j == i->second.begin())
				cout << *j;
			else
				cout << ", ", *j;
		cout << endl;
	}
}

// vim:set ts=3 sw=3:
