#include "Environment.h"
#include "Scans.h"
#include "ScanBag.h"

#include <stdio.h>
#include <iostream.h>

using namespace std;

void printCands(const vector<string>& v)
{
	for (vector<string>::const_iterator i = v.begin(); i != v.end(); i++)
		if (i != v.begin())
			cout << ", " << *i;
		else
			cout << *i;
}

Scan* s1 = new DefaultScan("default");
Scan* s20 = new LinkBeatScan("default");
Scan* s2 = new LinkBeatScan("nolink");
Scan* s21 = new ScriptScan("test0", "cmd-test0");
Scan* s3 = new ScriptScan("test1", "cmd-test1");
Scan* s4 = new ScriptScan("test2", "cmd-test2");
Scan* s5 = new ScriptScan("test1", "cmd-test2");
Scan* s6 = new ScriptScan("test3", "cmd-test3");

void initScans(ScanBag& sb)
{
	sb.clear();
	sb.add(s1);
	sb.add(s20);
	sb.add(s2);
	sb.add(s21);
	sb.add(s3);
	sb.add(s4);
	sb.add(s5);
	sb.add(s6);
}

int main(int argc, char* argv[])
{
	try {
		ScanBag sb;
		initScans(sb);
		//sb.dump();

		string res = sb.getLessSpecific();
		if (res != "default")
				error("Less specific at the beginning is %s instead of \"default\"", res.c_str());

		vector<string> v;

		v = sb.notify(s21);
		if (v.size() != 1)
			error("test0 should be the only candidate, but %d candidates are present", v.size());
		if (v[0] != "test0")
			error("test0 should be the resulting candidate, but %s is the result instead", v[0].c_str());

		initScans(sb);

		v = sb.notify(s4);
		//printf("Notified %.*s: ", PFSTR(s4->signature())); printCands(v); printf("\n");

		v = sb.notify(s3);
		//printf("Notified %.*s: ", PFSTR(s3->signature())); printCands(v); printf("\n");

		if (v.size() != 1)
			error("test1 should be the only candidate, but %d candidates are present", v.size());
		if (v[0] != "test1")
			error("test1 should be the resulting candidate, but %s is the result instead", v[0].c_str());

		initScans(sb);
		//sb.dump();
		v = sb.notify(s4);
		res = sb.getLessSpecific();
		if (res != "test2")
			error("test2 should be the resulting candidate, but %s is the result instead", res.c_str());

		fprintf(stderr, "\t\tDone.\n");
	}
	catch (std::exception& e)
	{
		error("%s\n", e.what());
		return 1;
	}
	return 0;
}

// vim:set ts=3 sw=3:
