//$Id: checkbox-canvas.cc,v 1.15 2001/11/25 19:50:20 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "checkbox-canvas.h"

#include "form-editor.h"

#include <gnome--/canvas-polygon.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>

#include "pixmaps/checkbox-canvas-on.xpm"
#include "pixmaps/checkbox-canvas-on-disabled.xpm"
#include "pixmaps/checkbox-canvas-off.xpm"
#include "pixmaps/checkbox-canvas-off-disabled.xpm"

using namespace Guikachu::GUI::FormEditor;

CheckboxCanvasItem::CheckboxCanvasItem (Widgets::Checkbox *widget_,
					FormEditor::Form    *form):
    CanvasItem (widget_, form),
    widget (widget_),
    group (0)
{
    update ();
}

void CheckboxCanvasItem::update ()
{
    if (group)
	delete group;

    group = new Gnome::CanvasGroup (*(form->get_canvas ()), 0, 0);
    
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    /* Don't ask about the +1, I have no idea... */
    int x1 = widget->x;
    int x2 = x1 + width + 1;
    int y1 = widget->y;
    int y2 = y1 + height + 1;

    /* A Polygon is used instead of a Rectangle to get mouse events
     * inside the "hollow" area
     */
    FormEditor::draw_rectangle (*group, x1, y1, x2, y2);
    
    int text_x = x1 + 17;
    int text_y = y1 + height / 2 - 2;

    GdkPixbuf *pixbuf;
    if (widget->toggled)
	if (widget->usable)
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_on_xpm);
	else
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_on_disabled_xpm);
    else
	if (widget->usable)
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_off_xpm);
	else
	    pixbuf = gdk_pixbuf_new_from_xpm_data ((const char**)checkbox_canvas_off_disabled_xpm);

    FormEditor::draw_pixbuf (*group, pixbuf,
			     widget->x + 2, widget->y + 1);
    gdk_pixbuf_unref (pixbuf);

    if (width > 18)
    {
	draw_text (*group,
		   widget->text, widget->font,
		   text_x, text_y,
		   widget->usable,
		   GTK_ANCHOR_WEST,
		   width - 16, height);
    }
    
    set_canvas_item (group);
}

void CheckboxCanvasItem::get_bounds (int &x1, int &y1,
				     int &x2, int &y2)
{
    int width = widget->get_display_width ();
    int height = widget->get_display_height ();

    width  = std::max (18, width);
    height = std::max (10, height);
    
    x1 = widget->x - 1;
    x2 = x1 + width + 1 + 1;
    y1 = widget->y - 1;
    y2 = y1 + height + 1;
}
