// This file has been copied 1:1 from www.spale.com/download/scrypt/scrypt1.0/sha256.c
// Besides these 2 comment lines and the correction of uint32 (see below) nothing has been changed.

#ifndef __SHA256_H__
#define __SHA256_H__

typedef unsigned int  uint32;
typedef unsigned char uint8;

#define SHA256_DIGEST_SIZE 32

#ifdef SHA256_OLD
   typedef struct
   {
      uint32 total[2];
      uint32 state[8];
      uint8 buffer[64];
   } t_SHA256Context, *t_pSHA256Context;

   void SHA256Init   (t_pSHA256Context pContext);
   void SHA256Append (t_pSHA256Context pContext, uint8 *input, uint32 length );
   void SHA256Finish (t_pSHA256Context pContext, uint8 digest[32] );
#else
   typedef struct
   {
      uint32 state[8];
      uint32 total[2];
      size_t buflen;
      uint32 buffer[32];
   } t_SHA256Context, *t_pSHA256Context;

   // Always make sure that these functions are compiled with O3 optimisation or
   // else, performance is about 5 times worse! See also SHA256ProcessBlock in sha256.cpp.
   void SHA256Init   (t_pSHA256Context pContext)                                 __attribute__((optimize("-O3")));
   void SHA256Append (t_pSHA256Context pContext, const void *buffer, size_t len) __attribute__((optimize("-O3")));
   void SHA256Finish (t_pSHA256Context pContext, void *pDigest)                  __attribute__((optimize("-O3")));
#endif

#endif

