/*
    gvidm - X11 video mode changer with a minimal interface
    Copyright (C) 2001 Matthew Mueller <donut@azstarnet.com>
    based on gvid:
    Copyright (C) 1999-2001 Keith Vanderline <kvand@mit.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gvid.h"

Display *display;

int switch_X11_Res(Display *display, int screen, XF86VidModeModeInfo **vm_modelines, int mode)
{
	XF86VidModeSwitchToMode(display, screen, vm_modelines[mode]);
	XFlush(display);
	return 1;
}

void MenuEvent (GtkWidget *widget, gpointer mode_ptr)
{
	XF86VidModeModeInfo **vm_modelines;
	int mode_int, vm_count, screen_count,i,j;

#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	memcpy(&mode_int, mode_ptr, sizeof(mode_int));

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	for (i=0; i<screen_count; i++)
	{
		XF86VidModeGetAllModeLines(display, i, &vm_count, &vm_modelines);
		for (j=0; j<vm_count; j++)
		{
			if (mode_int--==0) switch_X11_Res(display, i,vm_modelines,j);
		}
	}
}

void on_deactivate(void) {
	gtk_main_quit();
}

void create_popup(void)
{
	int i, j, vm_count, screen_count, *mode_ptr, mode_number, dotclock;
	char label_str[80];
	GtkWidget *menuitem_ptr, *submenu_ptr, *menu_ptr;
	XF86VidModeModeInfo **vm_modelines;
	XF86VidModeModeLine modeline;
#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	mode_number=0;

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	menu_ptr = gtk_menu_new();
	gtk_signal_connect (GTK_OBJECT (menu_ptr), "deactivate", GTK_SIGNAL_FUNC (on_deactivate), NULL);

	if (screen_count==1)
	{
		XF86VidModeGetAllModeLines(display, 0, &vm_count, &vm_modelines);
		XF86VidModeGetModeLine(display, 0, &dotclock, &modeline);
		for (j=0; j<vm_count; j++)
		{
			if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
				sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
			else
				sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

			mode_ptr = malloc(sizeof(mode_ptr));
			*mode_ptr = mode_number++;

			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
		}
	}
	else
	{
		for (i=0; i<screen_count; i++)
		{
			submenu_ptr = gtk_menu_new();
			sprintf(label_str, "Screen %i",i);
			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_menu_item_set_submenu(GTK_MENU_ITEM (menuitem_ptr), submenu_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
			gtk_widget_show(submenu_ptr);

			XF86VidModeGetAllModeLines(display, i, &vm_count, &vm_modelines);
			XF86VidModeGetModeLine(display, i, &dotclock, &modeline);
			for (j=0; j<vm_count; j++)
			{
				if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
					sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
				else
					sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

				mode_ptr = malloc(sizeof(mode_ptr));
				*mode_ptr = mode_number++;

				menuitem_ptr = gtk_menu_item_new_with_label(label_str);
				gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
				gtk_menu_append(GTK_MENU (submenu_ptr), menuitem_ptr);
				gtk_widget_show(menuitem_ptr);
			}
		}
	}

	gtk_menu_popup(GTK_MENU(menu_ptr), NULL, NULL, NULL, NULL, 0, 0);
}

gint main(int argc,char **argv)
{
	if ((display=XOpenDisplay(""))==NULL) exit(1);

	gtk_init (&argc, &argv);
	if (argc > 1) {
		printf("gvidm "M_VERSION" (C) 2001 Matthew Mueller <donut@azstarnet.com>\n"
				"based on gvid "VERSION" (C) 1999-2001 Keith Vanderline <kvand@mit.edu>\n"
				"Distributed under the terms of the GPL\n");
		printf("USAGE: gvidm [options]\n"
				" gvidm currently accepts only one option:\n"
				"  --help   show this info\n"
				" running with no options will popup a menu of possible resolutions.\n");
		return 0;
	}
	create_popup();
	gtk_main ();
	return 0;
}
