# -*- coding: latin-1 -*-

# Copyright (c) 2006 Stas Zykiewicz <stas.zytkiewicz@gmail.com>
#
#           Editors.py
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Provides a sourceview widget which is packed inside the glade generated 
# TextEditorWin from gvr_gtk.py
E_DEBUG = 0
import os
import utils
import pygtk
pygtk.require('2.0')
import gtk
import gtksourceview

class Editor:
    """Wraps a gtrksourceview widget and adds a few abstraction methods."""
    def __init__(self,parent,title=''):
        self.parent = parent
        
        self.srctagtable = gtksourceview.SourceTagTable()
        self.srcbuffer = gtksourceview.SourceBuffer(table=self.srctagtable)
        
        self.tag_h = self.srcbuffer.create_tag(background='lightblue')
        
        man = gtksourceview.SourceLanguagesManager()
        # Look for the locale to which the syntax highlighting should be set
        # We assume the locale is available, if not there won't be any higlighting.
        try:
            loc = utils.get_locale()[:2]
        except Exception,info:
            print info
            loc = ''
        if loc:
            mime = 'text/x-gvr_%s' % loc
        else:
            mime = 'text/x-gvr_en'
        if E_DEBUG: print "gtksourceview setting to %s" % mime
        lang = man.get_language_from_mime_type(mime)
        self.srcbuffer.set_language(lang)
        self.srcbuffer.set_highlight(True)
        self.srcbuffer.set_max_undo_levels(10)
        ######### test code
        if E_DEBUG: print "gtksourceview using",lang
        #########
        self.srcview = gtksourceview.SourceView(buffer=self.srcbuffer)
        self.srcview.set_show_line_numbers(True)
        self.srcview.set_tabs_width(4)
        self.srcview.set_insert_spaces_instead_of_tabs(True)
                
        self.parent.add(self.srcview)
        self.parent.show_all()
        
        self.old_start_iter = None

    def get_all_text(self):
        """Return all text from the widget"""
        startiter = self.srcbuffer.get_start_iter()
        enditer = self.srcbuffer.get_end_iter()
        txt = self.srcbuffer.get_text(startiter,enditer)
        if not txt:
            return []
        if '\n' in txt:
            txt = txt.split('\n')
        else:# assuming a line without a end of line
            txt = [txt]
        return txt
        
    def set_text(self,txt):
        """Load a text in the widget"""
        if E_DEBUG: print self.__class__,'set_text',txt
        try:
            txt = ''.join(txt)
            utxt = unicode(txt)
        except Exception,info:
            print "Failed to set text in source buffer"
            print info
            return
        self.srcbuffer.set_text(utxt)
        
    def set_highlight(self,line):
        """Highlight the line in the editor"""
        if self.old_start_iter:
            self.srcbuffer.remove_tag(self.tag_h,self.old_start_iter,self.old_end_iter)
        end_iter = self.srcbuffer.get_iter_at_line(line)
        end_iter.forward_to_line_end()  
        start_iter = self.srcbuffer.get_iter_at_line(line)
        self.srcbuffer.apply_tag(self.tag_h,start_iter,end_iter)
        self.old_start_iter,self.old_end_iter = start_iter,end_iter
    
    
            

