/*  -*-objc-*-
 *  DefaultSortTypeView.m: Implementation of the DefaultSortTypeView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "DefaultSortType.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation DefaultSortTypeView

- (void)dealloc
{
	RELEASE (matrix);
	RELEASE (setButt);
  [super dealloc];
}

- (id)init
{
	self = [super init];
	if(self) {
		NSBox *sortBox;
		NSString *localizedStr;
		id label, cell;

    gw = [GWorkspace gworkspace];	
		sortType = [gw defaultSortType];
	
		sortBox = [[NSBox alloc] initWithFrame: NSMakeRect(128, 105, 137, 125)];
  	[sortBox setBorderType: NSGrooveBorder];
		[sortBox setTitle: NSLocalizedString(@"Sort by", @"")];
  	[sortBox setTitlePosition: NSAtTop];
		[sortBox setContentViewMargins: NSMakeSize(2, 2)]; 
		[self addSubview: sortBox]; 
		RELEASE (sortBox);		

  	cell = [NSButtonCell new];
  	[cell setButtonType: NSRadioButton];
  	[cell setBordered: NO];
  	[cell setImagePosition: NSImageLeft];
		AUTORELEASE (cell);

  	matrix = [[NSMatrix alloc] 
					initWithFrame: NSMakeRect(40, 8, 80, 108)
						  			mode: NSRadioModeMatrix prototype: cell
															numberOfRows: 5 numberOfColumns: 1];

		[matrix setCellSize: NSMakeSize(80, 16)];	
		[matrix setIntercellSpacing: NSMakeSize(1, 2)];	
		[sortBox addSubview: matrix]; 

  	cell = [matrix cellAtRow: 0 column: 0];
  	[cell setTitle: NSLocalizedString(@"Name", @"")];
  	[cell setTag: byname];
  	cell = [matrix cellAtRow: 1 column: 0];
  	[cell setTitle: NSLocalizedString(@"Kind", @"")];
  	[cell setTag: bykind];
  	cell = [matrix cellAtRow: 2 column: 0];
  	[cell setTitle: NSLocalizedString(@"Date", @"")];
  	[cell setTag: bydate];
  	cell = [matrix cellAtRow: 3 column: 0];
  	[cell setTitle: NSLocalizedString(@"Size", @"")];
  	[cell setTag: bysize];
  	cell = [matrix cellAtRow: 4 column: 0];
  	[cell setTitle: NSLocalizedString(@"Owner", @"")];
  	[cell setTag: byowner];

		[matrix sizeToCells];
		[matrix selectCellAtRow: sortType column: 0];	
		[matrix setTarget: self];
		[matrix setAction: @selector(changeType:)];

		label = [[NSTextField alloc] initWithFrame: NSMakeRect(77, 61, 240, 40)];	
		[label setFont: [NSFont systemFontOfSize: 12]];
		[label setAlignment: NSCenterTextAlignment];
		[label setBackgroundColor: [NSColor windowBackgroundColor]];
		[label setTextColor: [NSColor grayColor]];	
		[label setBezeled: NO];
		[label setEditable: NO];
		[label setSelectable: NO];
		localizedStr = NSLocalizedString(@"The sort method will apply to all the folders\nthat have no sorting order specified", @"");
		[label setStringValue: localizedStr];
		[self addSubview: label]; 
		RELEASE (label);		
		
		setButt = [[NSButton alloc] initWithFrame: NSMakeRect(138, 33, 118, 24)];
		[setButt setButtonType: NSMomentaryLight];
		[setButt setTitle: NSLocalizedString(@"Set", @"")];	
    [setButt setTarget: self];
    [setButt setAction: @selector(setNewSortType:)];
		[setButt setEnabled: NO];	
		[self addSubview: setButt]; 
	}
	
	return self;
}

- (NSString *)prefsname
{
  return NSLocalizedString(@"Sorting Order", @"");
}

- (void)changeType:(id)sender
{
	sortType = [[sender selectedCell] tag];
	[setButt setEnabled: YES];
}

- (void)setNewSortType:(id)sender
{
  [gw setDefaultSortType: sortType];
	[setButt setEnabled: NO];
}

@end
