 /*  -*-objc-*-
 *  IconViewsPreferences.m: Implementation of the IconViewsPrefsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "IconViewsPreferences.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

#ifndef max
#define max(a,b) ((a) > (b) ? (a):(b))
#endif

#ifndef min
#define min(a,b) ((a) < (b) ? (a):(b))
#endif

extern NSString *GWCurrentSelectionChangedNotification;

@implementation ArrowResizer

- (void)dealloc
{
  RELEASE (arrow);
  [super dealloc];
}

- (id)initWithPosition:(ArrowPosition)pos inPrefView:(id)view
{
  self = [super init];
  [self setFrame: NSMakeRect(0, 0, 16, 16)];	  
  position = pos;
  prefview = view;
  
  if (position == leftarrow) {
    ASSIGN (arrow, [NSImage imageNamed: @"LeftArr.tiff"]);
  } else {
    ASSIGN (arrow, [NSImage imageNamed: @"RightArr.tiff"]);
  }
  
  return self;
}

- (ArrowPosition)position
{
  return position;
}

- (void)mouseDown:(NSEvent *)theEvent
{
  [prefview mouseDown: theEvent onResizer: self];
}

- (void)drawRect:(NSRect)rect
{
  [super drawRect: rect];
	[arrow compositeToPoint: NSZeroPoint operation: NSCompositeSourceOver];
}

@end

@implementation IconViewsPrefsView

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver: self];
  RELEASE (icon);
  RELEASE (fname);
  RELEASE (nameField);
  RELEASE (leftResizer);
  RELEASE (rightResizer);  
  RELEASE (cell);
	RELEASE (setButt);
  [super dealloc];
}

- (id)init
{
  self = [super init];
  
  if (self) {  
    NSArray *selPaths;
    int orx, framewdt, fieldwdt, count;
    
    gw = [GWorkspace gworkspace];    
		ws = [NSWorkspace sharedWorkspace];
		
    [self setFrame: NSMakeRect(0, 0, 394, 270)];	  

    cell = [[NSTextFieldCell alloc] initTextCell: NSLocalizedString(@"Title Width", @"")];
    [cell setAlignment: NSCenterTextAlignment];
    [cell setBordered: NO];
    [cell setEditable: NO];
    [cell setDrawsBackground: YES];

    selPaths = [gw selectedPaths];
    count = [selPaths count];

    if (count == 1) {    
      NSString *fpath = [selPaths objectAtIndex: 0];
      ASSIGN (fname, [fpath lastPathComponent]);
      ASSIGN (icon, [ws iconForFile: fpath]);          
    } else {
      fname = [[NSString alloc] initWithFormat: @"%i items", count];
      ASSIGN (icon, [NSImage imageNamed: @"MultipleSelection.tiff"]);
    }

    framewdt = [self frame].size.width; 
    cellsWidth = [gw iconViewCellsWidth];
    fieldwdt = cellsWidth;
        
    orx = (int)((framewdt - fieldwdt) / 2);

    nameField = [NSTextField new];
    [nameField setFrame: NSMakeRect(orx, 103, fieldwdt, 16)];    
		[nameField setBezeled: NO];
		[nameField setEditable: NO];
		[nameField setSelectable: NO];
		[nameField setAlignment: NSCenterTextAlignment];
	  [nameField setBackgroundColor: [NSColor whiteColor]];
		[nameField setStringValue: cutFileLabelText(fname, nameField, fieldwdt -6)];
		[self addSubview: nameField]; 

    leftResizer = [[ArrowResizer alloc] initWithPosition: leftarrow inPrefView: self];
    [leftResizer setFrame: NSMakeRect(orx - 16, 103, 16, 16)];
		[self addSubview: leftResizer]; 

    rightResizer = [[ArrowResizer alloc] initWithPosition: rightarrow inPrefView: self];
    [rightResizer setFrame: NSMakeRect(orx + fieldwdt, 103, 16, 16)];
		[self addSubview: rightResizer]; 

		setButt = [[NSButton alloc] initWithFrame: NSMakeRect(138, 66, 118, 24)];
		[setButt setButtonType: NSMomentaryLight];
		[setButt setTitle: NSLocalizedString(@"Use Default Settings", @"")];	
    [setButt setTarget: self];
    [setButt setAction: @selector(setDefaultWidth:)];	
    [setButt setEnabled: NO];
		[self addSubview: setButt]; 
    
    [[NSNotificationCenter defaultCenter] addObserver: self 
                					selector: @selector(selectionChanged:) 
                						  name: GWCurrentSelectionChangedNotification
                					  object: nil];
  }
  
  return self;
}

- (NSString *)prefsname
{
  return NSLocalizedString(@"Icon View", @"");
}

- (void)resizeParts
{
  NSArray *selPaths;
  int orx, framewdt, count;

  selPaths = [gw selectedPaths];
  count = [selPaths count];

  if (count == 1) {    
    NSString *fpath = [selPaths objectAtIndex: 0];
    ASSIGN (fname, [fpath lastPathComponent]);
    ASSIGN (icon, [ws iconForFile: fpath]);          
  } else {
    fname = [[NSString alloc] initWithFormat: @"%i items", count];
    ASSIGN (icon, [NSImage imageNamed: @"MultipleSelection.tiff"]);
  }

  framewdt = [self frame].size.width;    
  orx = (int)((framewdt - cellsWidth) / 2);

  [nameField setFrame: NSMakeRect(orx, 103, cellsWidth, 16)];    
  [nameField setStringValue: cutFileLabelText(fname, nameField, cellsWidth -6)];

  [leftResizer setFrame: NSMakeRect(orx - 16, 103, 16, 16)];
  [rightResizer setFrame: NSMakeRect(orx + cellsWidth, 103, 16, 16)];
  
  [self setNeedsDisplay: YES];
}

- (void)selectionChanged:(NSNotification *)n
{
  cellsWidth = [gw iconViewCellsWidth];
  [self resizeParts];
}

- (void)mouseDown:(NSEvent *)theEvent onResizer:(ArrowResizer *)resizer
{
  NSApplication	*app = [NSApplication sharedApplication];
  NSDate *farAway = [NSDate distantFuture];
  ArrowPosition pos = [resizer position];
  int framewdt = [self frame].size.width;
  int orx = (int)[self convertPoint: [theEvent locationInWindow] fromView: nil].x;
  ArrowResizer *resizer2 = (pos == leftarrow) ? rightResizer : leftResizer;
  unsigned int eventMask = NSLeftMouseUpMask | NSLeftMouseDraggedMask;
  NSEvent	*e;
  
  [self lockFocus];
  [[NSRunLoop currentRunLoop] limitDateForMode: NSEventTrackingRunLoopMode];

  e = [app nextEventMatchingMask: eventMask
		                   untilDate: farAway
			                    inMode: NSEventTrackingRunLoopMode
			                   dequeue: YES];

  while ([e type] != NSLeftMouseUp) {
    int x = (int)[self convertPoint: [e locationInWindow] fromView: nil].x;
    int diff = x - orx;
    NSRect r1 = [resizer frame];
    NSRect r2 = [resizer2 frame];
    int orx1 = (int)r1.origin.x;
    int orx2 = (int)r2.origin.x;

    if ((max(orx1 + diff, orx2 - diff) - min(orx1 + diff, orx2 - diff)) < 160
        && (max(orx1 + diff, orx2 - diff) - min(orx1 + diff, orx2 - diff)) > 70) {      
      int fieldwdt = max(orx1 + diff, orx2 - diff) - min(orx1 + diff, orx2 - diff) - 16;
      int nameforx = (int)((framewdt - fieldwdt) / 2);
      
      [resizer setFrameOrigin: NSMakePoint(orx1 + diff, 103)];
      [resizer setNeedsDisplay: YES];
      [resizer2 setFrameOrigin: NSMakePoint(orx2 - diff, 103)];
      [resizer2 setNeedsDisplay: YES];    
      [self setNeedsDisplayInRect: r1];
      [self setNeedsDisplayInRect: r2];   
      
      [nameField setFrame: NSMakeRect(nameforx, 103, fieldwdt, 16)];    
      [nameField setStringValue: cutFileLabelText(fname, nameField, fieldwdt -6)];
      [nameField setNeedsDisplay: YES];
       
      orx = x;
    }
    e = [app nextEventMatchingMask: eventMask
		                     untilDate: farAway
			                      inMode: NSEventTrackingRunLoopMode
			                     dequeue: YES];
  }
  [self unlockFocus];
  
  [self setNewWidth: (int)[nameField frame].size.width];
  
  [setButt setEnabled: YES];
}

- (void)setNewWidth:(int)w
{
  [gw setIconViewCellsWidth: w];
}

- (void)setDefaultWidth:(id)sender
{
  cellsWidth = [gw defaultIconViewCellsWidth];
  [self resizeParts];
  [setButt setEnabled: NO];
}

- (void)drawRect:(NSRect)rect
{
  NSRect r = NSMakeRect(98, 95, 197, 85);
  NSRect cellrect = NSMakeRect(163, 170, 67, 14);
  NSSize s = [icon size];
  NSPoint p = NSMakePoint((rect.size.width - s.width) / 2, 121);
  
  [super drawRect: rect];
  
  NSDrawGroove(r, r);
  
  [cell setBackgroundColor: [NSColor windowBackgroundColor]];
  [cell drawWithFrame: cellrect inView: self];
  
	[icon compositeToPoint: p operation: NSCompositeSourceOver];
}

@end
