 /*  -*-objc-*-
 *  DefaultEditor.m: Implementation of the DefaultEditorView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "ViewersPreferences.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation ViewersBox

- (void)dealloc
{
	RELEASE (backColor);
  [super dealloc];
}

- (id)init
{
	self = [super init];
	
	if (self) {
  	NSUserDefaults *defaults;	
  	NSDictionary *backColorPrefs;
		float r, g, b, alpha;

		defaults = [NSUserDefaults standardUserDefaults];    
  	backColorPrefs = [defaults dictionaryForKey: @"desktopviewprefs"];

  	if (backColorPrefs != nil) { 
    	id dictEntry = [backColorPrefs objectForKey: @"backcolor"];

    	if(dictEntry == nil) {
      	ASSIGN (backColor, [NSColor colorWithCalibratedRed: 0.49 green: 0.60 blue: 0.73 alpha: 1.00]);
    	} else {
      	r = [[dictEntry objectForKey: @"red"] floatValue];
      	g = [[dictEntry objectForKey: @"green"] floatValue];
      	b = [[dictEntry objectForKey: @"blue"] floatValue]; 
				alpha = [[dictEntry objectForKey: @"alpha"] floatValue];
      	ASSIGN (backColor, [NSColor colorWithCalibratedRed: r green: g blue: b alpha: alpha]);
    	}
  	} else {
			ASSIGN (backColor, [NSColor colorWithCalibratedRed: 0.49 green: 0.60 blue: 0.73 alpha: 1.00]);
		}
	}
	
	return self;
}

- (void)drawRect:(NSRect)rect
{
  float x = rect.origin.x + 2;
  float y = rect.origin.y + 2;
  float w = rect.size.width - 4;
  float h = rect.size.height - 20;
  NSRect colorRect = NSMakeRect(x, y, w, h);
  
  [super drawRect: rect];
    
  if (backColor != nil) {
    [backColor set];
    NSRectFill(colorRect);
  } 
}

@end

@implementation ViewersPrefsView

- (void)dealloc
{
	RELEASE (viewersDescription);
	RELEASE (revertDescription);	
  RELEASE (imView);
	RELEASE (vwrBox);
	RELEASE (chooseButt);
	RELEASE (leftButt);
	RELEASE (rightButt);
	RELEASE (setButt);	
	RELEASE (revertButt);
  [super dealloc];
}

- (id)init
{
  self = [super init];
  if (self) { 
    id label;
		
		[self setFrame: NSMakeRect(0, 0, 394, 270)];
				
		vwrBox = [[ViewersBox alloc] init];
		[vwrBox setFrame: NSMakeRect(102, 88, 190, 158)];
    [vwrBox setBorderType: NSGrooveBorder];
    [vwrBox setTitlePosition: NSAtTop];
		[vwrBox setContentViewMargins: NSZeroSize]; 
		[self addSubview: vwrBox]; 
		
		imView = [[NSImageView alloc] initWithFrame: NSMakeRect(20, 10, 150, 119)];
		[imView setImageFrameStyle: NSImageFrameNone];
		[imView setImageAlignment: NSImageAlignCenter];
		[imView setImageScaling: NSScaleNone];
		[vwrBox addSubview: imView]; 

		chooseButt = [[NSButton alloc] initWithFrame: NSMakeRect(102, 66, 16, 16)];
		[chooseButt setButtonType: NSSwitchButton];
		[chooseButt setAllowsMixedState: NO];
		[chooseButt setImagePosition: NSImageOnly];	
		[chooseButt setImage: [NSImage imageNamed: @"common_SwitchOff.tiff"]];			
		[chooseButt setAlternateImage: [NSImage imageNamed: @"common_SwitchOn.tiff"]];
		[chooseButt setTarget: self];
		[chooseButt setAction: @selector(addRemoveViewer:)];
		[self addSubview: chooseButt]; 

		leftButt = [[NSButton alloc] initWithFrame: NSMakeRect(179, 66, 16, 16)];
		[leftButt setButtonType: NSMomentaryLight];
		[leftButt setImagePosition: NSImageOnly];			
		[leftButt setImage: [NSImage imageNamed: @"common_ArrowLeftH.tiff"]];
		[leftButt setTarget: self];
		[leftButt setAction: @selector(showViewer:)];
		[self addSubview: leftButt]; 

		rightButt = [[NSButton alloc] initWithFrame: NSMakeRect(199, 66, 16, 16)];
		[rightButt setButtonType: NSMomentaryLight];
		[rightButt setImagePosition: NSImageOnly];	
		[rightButt setImage: [NSImage imageNamed: @"common_ArrowRightH.tiff"]];
		[rightButt setTarget: self];
		[rightButt setAction: @selector(showViewer:)];
		[self addSubview: rightButt]; 

		MAKE_LOCALIZED_LABEL (label, NSMakeRect(102, 42, 190, 20), @"Choose the viewers to use.", @"", 'c', YES, self);		  
    [label setTextColor: [NSColor grayColor]];

		setButt = [[NSButton alloc] initWithFrame: NSMakeRect(76, 12, 118, 24)];
		[setButt setButtonType: NSMomentaryLight];
		[setButt setTitle: NSLocalizedString(@"Activate changes", @"")];	
    [setButt setTarget: self];
    [setButt setAction: @selector(activateChanges:)];	
    [setButt setEnabled: NO];
		[self addSubview: setButt]; 

		revertButt = [[NSButton alloc] initWithFrame: NSMakeRect(200, 12, 118, 24)];
		[revertButt setButtonType: NSMomentaryLight];
		[revertButt setTitle: NSLocalizedString(@"Use Default Settings", @"")];	
    [revertButt setTarget: self];
    [revertButt setAction: @selector(revertToDefaults:)];	
    [revertButt setEnabled: NO];
		[self addSubview: revertButt]; 

		gw = [GWorkspace gworkspace];

		ASSIGN (revertDescription, [gw viewersDescription]);
		viewersDescription = [revertDescription mutableCopy];
		
		vwrindex = 0;
		[self showViewer: nil];
  }
  
  return self;
}

- (void)showViewer:(id)sender
{
	NSDictionary *viewerdict;
	NSImage *image;
	NSString *title;
	int count, state;
	
	count = [viewersDescription count];
	
	if (sender == rightButt) {
		vwrindex++;
		vwrindex = (vwrindex == count) ? 0 : vwrindex;		
	} else if (sender == leftButt) {		
		vwrindex--;
		vwrindex = (vwrindex < 0) ? count -1 : vwrindex;		
	} else {
		vwrindex = 0;
	}
		
	viewerdict = [viewersDescription objectAtIndex: vwrindex];
	image = [viewerdict objectForKey: @"preview"];
	[imView setImage: image];
		
	title = [viewerdict objectForKey: @"locname"];
	[vwrBox setTitle: title];

	state = [[viewerdict objectForKey: @"active"] intValue];
	[chooseButt setState: state];
}

- (void)addRemoveViewer:(id)sender
{
	int i;
	int count = [sender state];
	
	for (i = 0; i < [viewersDescription count]; i++) {
		NSDictionary *dict = [viewersDescription objectAtIndex: i];
		count += [[dict objectForKey: @"active"] intValue];
	}
	
	if (count == 1) {
		[sender setState: NSOnState];
		return;
	
	} else {
		NSMutableDictionary *viewerdict;
		int state, buttstate;
	
		viewerdict = [[viewersDescription objectAtIndex: vwrindex] mutableCopy];
		state = [[viewerdict objectForKey: @"active"] intValue];
		buttstate = [sender state];

		if (buttstate != state) {
			NSString *statestr = [NSString stringWithFormat: @"%i", buttstate];
			[viewerdict setObject: statestr forKey: @"active"];
			[viewersDescription replaceObjectAtIndex: vwrindex withObject: viewerdict];
			[setButt setEnabled: YES];
			
			if ([viewersDescription isEqual: revertDescription] == NO) {
				[setButt setEnabled: YES];
				[revertButt setEnabled: YES];
			}	else {
				[setButt setEnabled: NO];
				[revertButt setEnabled: NO];
			}
		}

		RELEASE (viewerdict);
	}
}

- (void)activateChanges:(id)sender
{
	[gw updateViewersDescription: viewersDescription];
	ASSIGN (revertDescription, [gw viewersDescription]);
	RELEASE (viewersDescription);
	viewersDescription = [revertDescription mutableCopy];
	[setButt setEnabled: NO];
	[revertButt setEnabled: NO];
	vwrindex = 0;
	[self showViewer: nil];
}

- (void)revertToDefaults:(id)sender
{
	NSDictionary *viewerdict;
	int state;
		
	RELEASE (viewersDescription);
	viewersDescription = [revertDescription mutableCopy];
	[setButt setEnabled: NO];
	[revertButt setEnabled: NO];
	
	viewerdict = [viewersDescription objectAtIndex: vwrindex];
	state = [[viewerdict objectForKey: @"active"] intValue];
	[chooseButt setState: state];
}

- (NSString *)prefsname
{
  return NSLocalizedString(@"Viewers", @"");
}

@end
