/* 
 * File: buttons.c
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GKrellM 2.0.0 or better and XMMS2 DR1 or better
 *
 * Released under the GNU General Public License v2
 */

#if !defined(WIN32)
#include <gkrellm2/gkrellm.h>
#else
#include <src/gkrellm.h>
#include <src/win32-plugin.h>
#endif

#include "buttons.h"
#include "button_prev.xpm"
#include "button_next.xpm"
#include "button_play.xpm"
#include "button_pause.xpm"
#include "button_stop.xpm"
#include "button_menu.xpm"

#define	STYLE_NAME	"gkrellxmms2"

void control_buttons_set_play_pause_button(ControlButtons *cb, gint status)
{
	if (status == PLAY_BUTTON) {
		gkrellm_show_button(cb->button_play);
		gkrellm_hide_button(cb->button_pause);
	} else if (status == PAUSE_BUTTON) {
		gkrellm_show_button(cb->button_pause);
		gkrellm_hide_button(cb->button_play);
	}
}

void control_buttons_create(ControlButtons *cb, GkrellmPanel *panel,
                            gint y,             void(*cb_button)())
{
	gfloat scale_factor = gkrellm_chart_width() / 75.0f;
	gint   button_space = (gint)(14.0f * scale_factor) * 5 + 4;
	gint   x = (gkrellm_chart_width() - button_space) / 2;

	gkrellm_load_piximage("button_prev", button_prev_xpm, 
	                      &cb->image_prev, STYLE_NAME); 
	cb->button_prev = gkrellm_make_scaled_button(panel,
				cb->image_prev,     /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(PREV_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */

	x = cb->button_prev->decal->x + cb->button_prev->decal->w + 1;

	gkrellm_load_piximage("button_play", button_play_xpm,
	                      &cb->image_play, STYLE_NAME); 
	cb->button_play = gkrellm_make_scaled_button(panel,
				cb->image_play,     /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(PLAY_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */

	gkrellm_load_piximage("button_pause", button_pause_xpm,
	                      &cb->image_pause, STYLE_NAME); 
	cb->button_pause = gkrellm_make_scaled_button(panel,
				cb->image_pause,    /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(PLAY_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */
	gkrellm_hide_button(cb->button_pause);

	x = cb->button_play->decal->x + cb->button_play->decal->w + 1;

	gkrellm_load_piximage("button_stop", button_stop_xpm,
	                      &cb->image_stop, STYLE_NAME); 
	cb->button_stop = gkrellm_make_scaled_button(panel,
				cb->image_stop,     /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(STOP_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */

	x = cb->button_stop->decal->x + cb->button_stop->decal->w + 1;

	gkrellm_load_piximage("button_next", button_next_xpm,
	                      &cb->image_next, STYLE_NAME); 
	cb->button_next = gkrellm_make_scaled_button(panel,
				cb->image_next,     /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(NEXT_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */

	x = cb->button_next->decal->x + cb->button_next->decal->w + 1;

	gkrellm_load_piximage("button_menu", button_menu_xpm,
	                      &cb->image_menu, STYLE_NAME); 
	cb->button_menu = gkrellm_make_scaled_button(panel,
				cb->image_menu,     /* GkrellmPiximage image to use to       */
				                    /* create the button images. Use a       */
				                    /* builtin default if NULL               */
				cb_button,          /* Button clicked callback function      */
				GINT_TO_POINTER(MENU_BUTTON), /* Arg to callback function    */
				FALSE,              /* auto_hide: if TRUE, button is visible */
				                    /* only when mouse is in the panel       */
				FALSE,              /* set_default_border: if TRUE, apply a  */
				                    /* default border of 1,1,1,1.  If false  */
				                    /* use the GkrellmPiximage border which  */
				                    /* in this case is 0,0,0,0               */
				0,                  /* Image depth if image != NULL          */
				0,                  /* Initial out frame if image != NULL    */
				1,                  /* Pressed frame if image != NULL        */
				x,                  /* x position of button                  */
				y,                  /* y position of button                  */
				14 * scale_factor,  /* Width for scaling the button          */
				15);                /* Height for scaling the button         */

	/* x = cb->button_menu->decal->x + cb->button_menu->decal->w + 1; */
}
