{-# hat-trans -cpp #-}
#if ( defined(__GLASGOW_HASKELL__) && __GLASGOW_HASKELL__ < 600 ) || \
    ( defined(__NHC__) && ( __NHC__ < 117 ) )
#define OLD
#endif
module Foreign.ForeignPtr
  ( ForeignPtr             -- abstract, instance of: Eq
#ifdef OLD
  , newForeignPtr          -- :: Ptr a -> IO () -> IO (ForeignPtr a)
  , addForeignPtrFinalizer -- :: ForeignPtr a -> IO () -> IO ()
  , foreignPtrToPtr        -- :: ForeignPtr a -> Ptr a
#else
  , FinalizerPtr           -- = FunPtr (Ptr a -> IO ())
  , newForeignPtr          -- :: FinalizerPtr a -> Ptr a -> IO (ForeignPtr a)
  , newForeignPtr_         -- ::                   Ptr a -> IO (ForeignPtr a)
  , addForeignPtrFinalizer -- :: FinalizerPtr a -> ForeignPtr a -> IO ()
  , unsafeForeignPtrToPtr  -- :: ForeignPtr a -> Ptr a
#endif
  , withForeignPtr         -- :: ForeignPtr a -> (Ptr a -> IO b) -> IO b
  , touchForeignPtr        -- :: ForeignPtr a -> IO ()
  , castForeignPtr         -- :: ForeignPtr a -> ForeignPtr b
  ) where

import PreludeBuiltinTypes
import Foreign.BuiltinTypes
import qualified TraceOrigForeign.ForeignPtr

#ifdef OLD
foreign import haskell "Foreign.ForeignPtr.foreignPtrToPtr"
  foreignPtrToPtr :: ForeignPtr a -> Ptr a
foreign import haskell "Foreign.ForeignPtr.newForeignPtr"
  newForeignPtr :: Ptr a -> IO () -> IO (ForeignPtr a)
foreign import haskell "Foreign.ForeignPtr.addForeignPtrFinalizer"
  addForeignPtrFinalizer :: ForeignPtr a -> IO () -> IO ()
#else
-- type FinalizerPtr a = FunPtr (Ptr a -> IO ())
foreign import haskell "Foreign.ForeignPtr.newForeignPtr"
  newForeignPtr :: FinalizerPtr a -> Ptr a -> IO (ForeignPtr a)
foreign import haskell "Foreign.ForeignPtr.newForeignPtr_"
  newForeignPtr_ :: Ptr a -> IO (ForeignPtr a)
foreign import haskell "Foreign.ForeignPtr.addForeignPtrFinalizer"
  addForeignPtrFinalizer :: FinalizerPtr a -> ForeignPtr a -> IO ()
foreign import haskell "Foreign.ForeignPtr.unsafeForeignPtrToPtr"
  unsafeForeignPtrToPtr :: ForeignPtr a -> Ptr a
#endif
foreign import haskell "Foreign.ForeignPtr.withForeignPtr"
  withForeignPtr :: ForeignPtr a -> (Ptr a -> IO b) -> IO b
foreign import haskell "Foreign.ForeignPtr.touchForeignPtr"
  touchForeignPtr :: ForeignPtr a -> IO ()
foreign import haskell "Foreign.ForeignPtr.castForeignPtr"
  castForeignPtr :: ForeignPtr a -> ForeignPtr b

--
foreign import haskell "Prelude.=="
  eqForeignPtr :: ForeignPtr a -> ForeignPtr a -> Bool
--foreign import haskell "Prelude.<="
--  leForeignPtr :: ForeignPtr a -> ForeignPtr a -> Bool
foreign import haskell "Prelude.showsPrec"
  showsPrecForeignPtr :: Int -> ForeignPtr a -> String -> String

instance Eq (ForeignPtr a) where (==) = eqForeignPtr
--instance Ord (ForeignPtr a) where (<=)= leForeignPtr
instance Show (ForeignPtr a) where showsPrec = showsPrecForeignPtr
