/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "Console.h"
#include "palette.h"
#include "../util/debug.h"

static bool setPalette(uint8 i, uint16 r, uint16 g, uint16 b)
{
 // FIXME I don't know if either of the below functions should be checked for failing

#ifdef GGI
 ggi_color color = { r, g, b, 0 };
 ggiSetPalette(consoleVisual, i, 1, &color);
#endif

#ifdef SVGALIB
 vga_setpalette(i, r >> 10, g >> 10, b >> 10);
#endif

 return true;
}

bool setPalette()
{
 if(!setPalette(0, 0, 0, 0)) return false;
 for(int r=0; r<6; r++) for(int g=0; g<7; g++) for(int b=0; b<6; b++)
  if(!setPalette(1 + 6 * (7*r + g) + b, r * 65535 / 5, g * 65535 / 6, b * 65535 / 5)) return false;
 return true;
}
