/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef main_Actor_h
#define main_Actor_h

#include "Dir.h"
#include "globals.h"
#include "Pos.h"
#include "../util/Object.h"
#include "../gl/mode.h"

class Actor : public Object
{
public:
 bool moving;

 Actor();
 virtual ~Actor();
 bool move();
 void setPos(Pos _p);
 void setDir(Dir _dir);
 Point screenPos() { return Point(p.x * sprW + q * xInc[dir], p.y * sprH + q * yInc[dir]) + stagePos; }
 Dir getDir() { return dir; }
 int getDisplacement() { return q; }
 Pos getPos() { return p; }
 bool onSquare() { return q? false : true; }
 void start() { moving = true; }
 void stop() { moving = false; }
 void turnBack();
private:
 Pos p;
 int q;
 Dir dir;
};

#endif
