/*C* $Id: ghost.h,v 1.4 1997/08/14 22:10:51 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef src_Ghost_h
#define src_Ghost_h

#include "Actor.h"
#include "Dir.h"
#include "globals.h"
#include "Pos.h"

class Ghost : public Actor
{
public:
 Ghost(int _x, int _y, int _defaultSprite);
 virtual ~Ghost();

 enum { Alive, Scared, Dead } state;
 static int flash;

 void restart();

 void draw();
 
 void pellet();
 void pelletEnd() { if(state != Dead) state = Alive; }

private:
 Pos start;
 int defaultSprite;
};

#endif
