#							-*- shell-script -*-

# Copyright by The HDF Group.
# Copyright by the Board of Trustees of the University of Illinois.
# All rights reserved.
#
# This file is part of HDF5.  The full HDF5 copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the files COPYING and Copyright.html.  COPYING can be found at the root
# of the source code distribution tree; Copyright.html can be found at the
# root level of an installed copy of the electronic HDF5 document set and
# is linked from the top-level documents page.  It can also be found at
# http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have
# access to either file, you may request a copy from help@hdfgroup.org.

#
# This file is part of the HDF5 build script.  It is processed shortly
# after configure starts and defines, among other things, flags for
# the various compile modes.


#----------------------------------------------------------------------------
# Compiler flags. The CPPFLAGS values should not include package debug
# flags like `-DH5G_DEBUG' since these are added with the
# `--enable-debug' switch of configure.
#----------------------------------------------------------------------------


# Choosing a C++ Compiler
# -----------------------
#
# The user should be able to specify the compiler by setting the CXX
# environment variable to the name of the compiler and any switches it 
# requires for proper operation.  If CXX is unset then this script may
# set it.  If CXX is unset by time this script completes then configure 
# will try `g++' and `CC' in that order (perhaps some others too).
#
# Note: Code later in this file may depend on the value of $CXX_BASENAME
#       in order to distinguish between different compilers when
#       deciding which compiler command-line switches to use.  This
#       variable is set based on the incoming value of $CC and is only
#       used within this file.

if test -z "$CXX"; then
    CXX="CC"
    CXX_BASENAME=CC
fi


# C++ Compiler and Preprocessor Flags
# -----------------------------------
#
# Flags that end with `_CXXFLAGS' are always passed to the compiler.
# Flags that end with `_CPPFLAGS' are passed to the compiler when
# compiling but not when linking.
#
# DEBUG_CXXFLAGS	Flags to pass to the compiler to create a
# DEBUG_CPPFLAGS	library suitable for use with debugging
#			tools. Usually this list will exclude
#			optimization switches (like `-O') and include
#			switches that turn on symbolic debugging
#			support (like `-g').
#
# PROD_CXXFLAGS		Flags to pass to the compiler to create a
# PROD_CPPFLAGS		production version of the library.  These
#			usualy exclude symbolic debugging switches
#			(like `-g') and include optimization switches
#			(like `-O').
#
# PROFILE_CXXFLAGS	Flags to pass to the compiler to create a
# PROFILE_CPPFLAGS	library suitable for performance testing (like 
# 			`-pg').  This may or may not include debugging 
# 			or production flags.
#			
# CXXFLAGS		Flags can be added to this variable which
#			might already be partially initialized.  These 
#			flags will always be passed to the compiler
#			and should include switches to turn on full
#			warnings.  HDF5 attempts to be ANSI and Posix
#			compliant and employ good programming
#			practices resulting in few if any
#			warnings.
#
#			Warning flags do not have to be added to CFLAGS
#			variable if the compiler is the GNU gcc
#			compiler or a descendent of gcc such as EGCS or PGCC.
#
#			The CFLAGS should contains *something* or else 
#			configure will probably add `-g'.  For most
#			systems this isn't a problem but some systems
#			will disable optimizations in favor of the
#			`-g'.
#			
#
# These flags should be set according to the compiler being used.
# There are two ways to check the compiler.  You can try using `-v' or 
# `--version' to see if the compiler will print a version string.  You 
# can use the value of $CXX_BASENAME which is the base name of the
# first word in $CXX (note that the value of CXX may have changed
# above).

case $CXX_BASENAME in
    g++)
	CXXFLAGS="$CXXFLAGS -Wsign-compare" #Only works for some versions
	DEBUG_CXXFLAGS="-g -fverbose-asm"
	DEBUG_CPPFLAGS=
	PROD_CXXFLAGS="-O3 -fomit-frame-pointer"
	PROD_CPPFLAGS=
	PROFILE_CXXFLAGS="-pg"
	PROFILE_CPPFLAGS=
	;;

    *)
	CXXFLAGS="$CXXFLAGS -h instantiate=used"
	DEBUG_CXXFLAGS="-g"
	DEBUG_CPPFLAGS=
	PROD_CXXFLAGS="-O"
	PROD_CPPFLAGS=
	PROFILE_CXXFLAGS="-pg"
	PROFILE_CPPFLAGS=
	;;
esac



# Overriding Configure Tests
# --------------------------
#
# Values for overriding configuration tests when cross compiling.
# This includes compiling on some machines where the serial front end
# compiles for a parallel back end.

# Set this to `yes' or `no' depending on whether the target is big
# endian or little endian.
#ac_cv_c_bigendian=${ac_cv_c_bigendian='yes'}

# Set this to the width required by printf() to print type `long
# long'.  For instance, if the format would be `%lld' then set it to
# `ll' or if the format would be `%qd' set it to `q'.
#hdf5_cv_printf_ll=${hdf5_cv_printf_ll='ll'}
