#ifndef _THRESHOLDHEAP_H_
#define _THRESHOLDHEAP_H_

// A threshold heap keeps no more than ThresholdBytes worth of memory around
// as a local allocation cache. It also obtains memory using multifree & multimalloc,
// so the parent heap must support those methods.


#include <assert.h>

template <int ThresholdBytes, class SuperHeap>
class ThresholdHeap : public SuperHeap {
public:

	ThresholdHeap (void)
	{
		myFreelist[0] = myFreelist[1] = NULL;
		nObjects[0] = nObjects[1] = 0;
	}

	~ThresholdHeap (void)
	{
#if 0 // FIX ME?
		for (int i = 0; i < 2; i++) {
			if (myFreelist[i] != NULL) {
				assert (nObjects[i] > 0);
				SuperHeap::multifree (nObjects[i], myFreelist[i]);
			}
		}
#endif
	}

	void * malloc (size_t sz) {

		assert (sz <= ThresholdBytes / 2);
		// If we're all out of memory, refill the freelist.
		if (nObjects[0] == 0) {
			assert (nObjects[1] == 0);
			// Get ThresholdBytes/2 worth of memory.
			int n = (ThresholdBytes / 2) / sz;
			nObjects[0] = SuperHeap::multimalloc (n, sz, (void *&) myFreelist[0]);
			assert (size(myFreelist[0]) >= sz);
			assert (nObjects[0] >= 1);
		}
		// Get an object from a freelist.
		// We preferentially remove from freelist 1.
		void * ptr;
		int index;
		if (myFreelist[1] == NULL) {
			index = 0;
		} else {
			index = 1;
		}
		assert (nObjects[index] > 0);
		ptr = myFreelist[index];
		myFreelist[index] = myFreelist[index]->next;
		nObjects[index]--;
		assert (size(ptr) >= sz);
		return ptr;
	}

	void free (void * ptr) {

		// Add this item to our freelist.
		int index;
		if (nObjects[0] * size(ptr) >= (ThresholdBytes / 2)) {
			// We have filled up freelist 0:
			// add this object to freelist 1.
			index = 1;
		} else {
			index = 0;
		}
		((freeObject *) ptr)->next = myFreelist[index];
		myFreelist[index] = (freeObject *) ptr;
		nObjects[index]++;
		// If we now have exceeded our threshold,
		// free half of them.
		if (nObjects[0] == nObjects[1]) {
			assert (nObjects[1] == (ThresholdBytes / 2) / size(ptr));
			SuperHeap::multifree (nObjects[1], myFreelist[1]);
			myFreelist[1] = NULL;
			nObjects[1] = 0;
		}
	}

private:

  class freeObject {
  public:
    freeObject * next;
  };

  freeObject * myFreelist[2];
	int nObjects[2];

};


#endif
