/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: testbomb.cpp,v 1.1.26.1 2004/07/09 01:54:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#define INITGUID

// system
#include <stdio.h>

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxvsurf.h"
#include "ihxpckts.h"

// hxmisc
#include "baseobj.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif
#include "hxassert.h"

// pxcomlib
#include "makebomb.h"
#include "pxcontxt.h"
#include "pximage.h"

void main(int argc, char** argv)
{
    // Check args
    if (argc != 4)
    {
        fprintf(stderr, "Usage: testbomb width height outfilename\n");
        return;
    }

    // Get the command-line args
    UINT32 ulWidth  = (UINT32) atoi(argv[1]);
    UINT32 ulHeight = (UINT32) atoi(argv[2]);

    // Create the test context
    PXTestContext* pContext = NULL;
    HX_RESULT      retVal   = PXTestContext::CreateObject(&pContext);
    if (SUCCEEDED(retVal))
    {
        // Addref the object
        pContext->AddRef();
        // Get an IUnknown interface from the context
        IUnknown* pUnknown = NULL;
        retVal             = pContext->QueryInterface(IID_IUnknown,
                                                      (void**) &pUnknown);
        if (SUCCEEDED(retVal))
        {
            PXMakeBombImage* pMakeBomb = new PXMakeBombImage();
            if (pMakeBomb)
            {
                PXImage* pImage = NULL;
                retVal = pMakeBomb->MakeBombImage(pContext, ulWidth, ulHeight, 0, pImage);
                if (SUCCEEDED(retVal))
                {
                    pImage->Write(argv[3], PXImage::kWriteFormatBinaryRaw);
                }
                HX_RELEASE(pImage);
            }
            else
            {
                retVal = HXR_OUTOFMEMORY;
            }
            HX_DELETE(pMakeBomb);
        }
        HX_RELEASE(pUnknown);
    }
    HX_RELEASE(pContext);
}
