/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mainapp.h,v 1.9.2.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __MAIN_APP_H__
#define __MAIN_APP_H__

#include "commonapp.h"
#include "hxplayer.h"

G_BEGIN_DECLS

struct _HXMainWindow;
typedef struct _HXMainWindow HXMainWindow;

typedef enum
{
    NORMAL_SIZE = 0,
    DOUBLE_SIZE,
    CUSTOM_SIZE
} HXMainWindowZoomSize;
    
HXMainWindow* hxwindow_new          (void);

GtkWidget* hxwindow_get_player      (HXMainWindow* window);
GtkWidget* hxwindow_get_window      (HXMainWindow* window);

gboolean   hxwindow_is_fullscreened (HXMainWindow* window);
GladeXML*  hxwindow_get_glade_xml   (HXMainWindow* window);

void       hxwindow_open_location   (HXMainWindow* window);
void       hxwindow_open_file       (HXMainWindow* window);
void       hxwindow_open            (HXMainWindow* window,
                                     const gchar*  uri);
void       hxwindow_play            (HXMainWindow* window);
void       hxwindow_pause           (HXMainWindow* window);
void       hxwindow_play_pause      (HXMainWindow* window);
void       hxwindow_stop            (HXMainWindow* window);
void       hxwindow_previous        (HXMainWindow* window);
void       hxwindow_next            (HXMainWindow* window);
void       hxwindow_fast_forward    (HXMainWindow* window);
void       hxwindow_rewind          (HXMainWindow* window);    
void       hxwindow_save_preferences(HXMainWindow* player,
                                     GIOChannel*   chan);
void       hxwindow_volume_change   (HXMainWindow* player,
                                     gint          delta);
void       hxwindow_change_layout   (HXMainWindow* window);

void       hxwindow_show_menu_and_caption  (HXMainWindow* window,
                                            gboolean      show);
void       hxwindow_show_controls          (HXMainWindow* window,
                                            gboolean      show);
void       hxwindow_show_status_bar        (HXMainWindow* window,
                                            gboolean      show);

HXContentStateType hxwindow_get_content_state(HXMainWindow* window);

void hxwindow_recent_urls_prepend(HXMainWindow* window,
                                  const gchar*  url);
void hxwindow_recent_urls_append(HXMainWindow* window,
                                 const gchar*  url);
void hxwindow_recent_urls_hide  (HXMainWindow* window);
void hxwindow_recent_urls_show  (HXMainWindow* window);
void hxwindow_recent_urls_remove_all(HXMainWindow* window);
    
void hxwindow_favorite_add      (HXMainWindow* window,
                                 const gchar*  favorite_title,
                                 const gchar*  favorite_url);    
void hxwindow_set_property      (HXMainWindow* window,
                                 const gchar*  key,
                                 GValue*       value);
gboolean hxwindow_get_property  (HXMainWindow* window,
                                 const gchar*  key,
                                 GValue*       value);

void hxwindow_on_top_always       (HXMainWindow* window);
void hxwindow_on_top_while_playing(HXMainWindow* window);
void hxwindow_on_top_never        (HXMainWindow* window);
void hxwindow_set_quit_on_done    (HXMainWindow* window,
                                   gboolean      quit);
void hxwindow_fullscreen          (HXMainWindow* window);
void hxwindow_unfullscreen        (HXMainWindow* window);

HXMainWindowZoomSize hxwindow_get_zoom (HXMainWindow* window);
void                 hxwindow_set_zoom (HXMainWindow* window,
                                        HXMainWindowZoomSize zoom);

#ifdef HELIX_FEATURE_RP_SIGN_IN
void hxwindow_set_sign_in_property(HXMainWindow* window,
                                   const gchar*  key,
                                   const gchar*  value);

G_CONST_RETURN gchar*
     hxwindow_get_sign_in_property(HXMainWindow* window,
                                   const gchar*  key);
#endif
    
G_END_DECLS

#endif
