/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: tokenizer.cpp,v 1.7.8.3 2004/07/09 01:48:45 hubbe Exp $
 * 
 * * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "tokenizer.h"

CStringTokenizer::CStringTokenizer(const char *szString)
    : m_pPos(szString)
{
}

CStringTokenizer::~CStringTokenizer()
{
}

void CStringTokenizer::SkipWhiteSpace()
{
    while(*m_pPos != '\0' &&
          (isspace(*m_pPos) ||
           *m_pPos == '\r'  ||
           *m_pPos == '\n' ||
           *m_pPos == ','))
    {
        m_pPos++;
    }
}

char *CStringTokenizer::RemainingChars()
{
    return strdup(m_pPos);
}



// Caller must free returned string
char *CStringTokenizer::NextToken()
{
    char *pToken = NULL;
    
    SkipWhiteSpace();
    
    if(*m_pPos == '"')
    {            
        char *pTokenPos;
        int bDone = 0;
    
        // Skip opening quote
        m_pPos++;

        // Worst case size of our token
        pToken = (char*)malloc(strlen(m_pPos) + 1);
        pTokenPos = pToken;

        while(*m_pPos && !bDone)
        {
            switch(*m_pPos)
            {
                case '"':
                    // End of token
                    *pTokenPos++ = '\0';
                    bDone = 1;
                    break;

                case '\\':
                    m_pPos++;
                    if(*m_pPos == '"'  ||
                       *m_pPos == '\\' ||
                       *m_pPos == '`'  ||
                       *m_pPos == '$'  ||
                       *m_pPos == '\n')
                    {
                        *pTokenPos++ = *m_pPos;
                    }
                    else
                    {
                        *pTokenPos++ = '\\';
                        *pTokenPos++ = *m_pPos;
                    }
                    break;
                    
                default:
                    *pTokenPos++ = *m_pPos;
                    break;
            }
            m_pPos++;
        }
    }
    else if(*m_pPos == '\'')        
    {    
        char *pTokenPos;
        int bDone = 0;
    
        // Skip opening quote
        m_pPos++;

        // Worst case size of our token
        pToken = (char*)malloc(strlen(m_pPos) + 1);
        pTokenPos = pToken;

        m_pPos++; // Skip opening quote
        
        while(*m_pPos && !bDone)
        {
            switch(*m_pPos)
            {
                case '\'':                    
                    // End of token
                    if(strcmp("\\''", m_pPos+1) == 0)
                    {
                        // We're really escaping a single quote                        
                        *pTokenPos++ = '\'';
                        m_pPos += 3;
                    }
                    else
                    {
                        *pTokenPos++ = '\0';
                        bDone = 1;
                    }
                    break;

                default:
                    *pTokenPos++ = *m_pPos;
                    break;

            }
            m_pPos++;
        }
    }
    else
    {
        /* Not a quote -- whitespace delimited */
        const char *pStart = NULL;
        const char *pEnd = NULL;
        int nLen = 0;

        pStart = m_pPos;

        while(*m_pPos && (!isspace(*m_pPos) && *m_pPos != ','))
        {
            m_pPos++;
        }

        pEnd = m_pPos;

        nLen = pEnd - pStart;
    
        pToken = (char*)malloc(nLen + 1);
        if(pToken)
        {
            strncpy(pToken, pStart, nLen);
            pToken[nLen] = '\0';
        }
    }
    
    return pToken;
}

