/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import java.util.ArrayList;

import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.w3c.dom.Node;

public class NodeCountVisitor extends AbstractNodeVisitor implements INodeVisitor {

	private int counter = 0;
	
	public NodeCountVisitor(ArrayList<ProgressListener> listeners) {
		super(listeners);
	}
	
	public int getNumberOfNodes() {
		return counter;
	}
	
	public void accept(Node node) {

		counter++;
		fireProgressEvent(String.valueOf(counter), ProgressEvent.STAGE_PREPARE);
	}

	public INodeVisitor reset() {
		counter = 0;
		return this;
	}

	@Override
	public void openTag(Node node) {
		//
	}

	@Override
	public void closeTag(Node node) {
		//
	}

}
