/*
 * hfsputils - tools for reading and writing Macintosh HFS+ volumes
 *
 * This program allows to "mount" a device. In fact it does so
 * by creating some addtional info in the users home directory
 *
 * Copyright (C) 2000 Klaus Halfmann <khalfmann@libra.de>
 * Original 1996-1998 Robert Leslie <rob@mars.org>
 * Additional work by  Brad Boyer (flar@pants.nu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: hpmount.c,v 1.5 2000/09/26 06:27:44 hasi Exp $
 */

# ifdef HAVE_CONFIG_H
#  include "config.h"
# endif

# include <stdio.h>
# include <stdlib.h>

# include "libhfsp.h"
# include "volume.h"

# include "hpcache.h"
# include "hfsputil.h"

/*
 * NAME:	hpmount->main()
 * DESCRIPTION:	implement hpmount command
 */
int main(int argc, char *argv[])
{
    char*   path = NULL;
    volume  vol;
    record  rec;
    int	    result = 0;

    if (argc != 2)
    {
	fprintf(stderr, "Usage: %s source-path \n", argv[0]);
	goto fail;
    }

    path = hfsputil_abspath(argv[1]);
    if (!path)
    {
	fprintf(stderr, "%s: not enough memory\n", argv0);
	goto fail;
    }

    // suid_enable();
    result = hpcache_open(&vol, &rec, path);
    // suid_disable();

    if (result)
	hfsputil_perror(path);

    result = volume_close(&vol) || result;

    free(path);

    return result;

    fail:
    if (path)
        free(path);

    return 1;
}
