{- This module was generated from data in the Kate syntax
   highlighting file cs.xml, version 1.15, by  -}

module Text.Highlighting.Kate.Syntax.Cs
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "C#"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cs"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "C#" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("C#",["Normal"])], synStLanguage = "C#", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext) >> pEndLine
    "Member" -> (popContext) >> pEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "abstract as base break case catch class checked continue default delegate do else enum event explicit extern false for foreach finally fixed goto if implicit in interface internal is lock namespace new null operator out override params private protected public readonly ref return sealed sizeof stackalloc static struct switch this throw true try typeof unchecked unsafe using virtual while #if #else #elif #endif #define #undef #warning #error #line"
list_types = Set.fromList $ words $ "bool byte char const decimal double float int long object uint ushort ulong sbyte short string void"

regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 = compileRegex "\\bpartial(?=\\s+(class|struct|interface|void))"
regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 = compileRegex "\\bvar(?=\\s+\\w+\\s*=\\s*\\w+)"
regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 = compileRegex "\\byield(?=\\s+(return|break))"
regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 = compileRegex "\\b(set|get)(?=\\s*[;{])"
regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 = compileRegex "\\bglobal(?=\\s*::\\s*\\w+)"
regex_'23region'2e'2a'24 = compileRegex "#region.*$"
regex_'23endregion'2e'2a'24 = compileRegex "#endregion.*$"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*[(])"
regex_'5b'2e'5d'7b1'2c1'7d = compileRegex "[.]{1,1}"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*)"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("Member",NormalTok),("Commentar 1",CommentTok),("Commentar 2",CommentTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Commentar 1")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Commentar 2")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'23region'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'23endregion'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5b'2e'5d'7b1'2c1'7d >>= withAttribute NormalTok) >>~ pushContext "Member")
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok)))

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Member" =
  (((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Commentar 1" =
  pzero

parseRules "Commentar 2" =
  ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
