{- This module was generated from data in the Kate syntax
   highlighting file d.xml, version 1.62, by Diggory Hardy (diggory.hardy@gmail.com), Aziz Köksal (aziz.koeksal@gmail.com), Jari-Matti Mäkelä (jmjm@iki.fi), Simon J Mackenzie (project.katedxml@smackoz.fastmail.fm) -}

module Text.Highlighting.Kate.Syntax.D
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "D"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.d;*.D;*.di;*.DI;"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "D" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("D",["normal"])], synStLanguage = "D", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "normal" -> return ()
    "StartingLetter" -> (popContext) >> pEndLine
    "Properties" -> return ()
    "NumberLiteral" -> return ()
    "LinePragma" -> (popContext) >> pEndLine
    "UnicodeShort" -> (popContext) >> pEndLine
    "UnicodeLong" -> (popContext) >> pEndLine
    "HTMLEntity" -> (popContext) >> pEndLine
    "ModuleName" -> return ()
    "Linkage" -> return ()
    "Linkage2" -> return ()
    "Version" -> return ()
    "Version2" -> return ()
    "Scope" -> return ()
    "Scope2" -> return ()
    "Pragma" -> return ()
    "Pragma2" -> return ()
    "RawString" -> return ()
    "BQString" -> return ()
    "HexString" -> return ()
    "CharLiteral" -> pushContext "CharLiteralClosing" >> return ()
    "CharLiteralClosing" -> (popContext >> popContext) >> pEndLine
    "String" -> return ()
    "CommentRules" -> (popContext) >> pEndLine
    "Region Marker" -> (popContext) >> pEndLine
    "CommentLine" -> (popContext) >> pEndLine
    "CommentBlock" -> return ()
    "CommentNested" -> return ()
    "DdocNormal" -> return ()
    "DdocLine" -> (popContext) >> pEndLine
    "DdocBlock" -> return ()
    "DdocNested" -> return ()
    "DdocNested2" -> return ()
    "DdocMacro" -> return ()
    "DdocMacro2" -> return ()
    "DdocMacro3" -> return ()
    "MacroRules" -> return ()
    "DdocBlockCode" -> return ()
    "DdocNestedCode" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_userkeywords = Set.fromList $ words $ ""
list_statements = Set.fromList $ words $ "asm body break case catch continue default do else finally for foreach foreach_reverse goto if mixin return switch throw try while with synchronized"
list_attributes = Set.fromList $ words $ "abstract align auto const export final immutable inout invariant lazy nothrow override package private protected public pure ref static out scope"
list_expressions = Set.fromList $ words $ "false null super this true typeid assert cast is new delete in delegate function"
list_modules = Set.fromList $ words $ "module import"
list_declarators = Set.fromList $ words $ "alias enum typedef class interface struct union"
list_types = Set.fromList $ words $ "typeof void bool byte ubyte short ushort int uint long ulong cent ucent float double real ireal ifloat idouble creal cfloat cdouble char wchar dchar"
list_templates = Set.fromList $ words $ "macro template"
list_properties = Set.fromList $ words $ "init sizeof alignof mangleof stringof tupleof offsetof max min infinity nan dig epsilon mant_dig max_10_exp max_exp min_10_exp min_exp re im length ptr dup idup reverse sort keys values rehash"
list_libsymbols = Set.fromList $ words $ "size_t ptrdiff_t hash_t Error Exception Object TypeInfo ClassInfo ModuleInfo Interface OffsetTypeInfo TypeInfo_Typedef TypeInfo_Enum TypeInfo_Pointer TypeInfo_Array TypeInfo_StaticArray TypeInfo_AssociativeArray TypeInfo_Function TypeInfo_Delegate TypeInfo_Class TypeInfo_Interface TypeInfo_Struct TypeInfo_Tuple string wstring dstring bit TypeInfo_Const TypeInfo_Invariant"
list_linkage = Set.fromList $ words $ "extern"
list_ltypes = Set.fromList $ words $ "C D Windows Pascal System"
list_ptypes = Set.fromList $ words $ "msg lib"
list_scope'5fkeywords = Set.fromList $ words $ "exit success failure"
list_vtypes = Set.fromList $ words $ "DigitalMars X86 X86_64 Windows Win32 Win64 linux LittleEndian BigEndian D_Coverage D_InlineAsm_X86 unittest D_Version2 none all"
list_specialtokens = Set.fromList $ words $ "__FILE__ __LINE__ __DATE__ __TIME__ __TIMESTAMP__ __VENDOR__ __VERSION__ __EOF__"
list_tests = Set.fromList $ words $ "debug unittest"
list_pragma = Set.fromList $ words $ "pragma"
list_version = Set.fromList $ words $ "version"
list_deprecated = Set.fromList $ words $ "deprecated volatile"

regex_'5ba'2dzA'2dZ'5f'5d = compileRegex "[a-zA-Z_]"
regex_'5c'2e'5cd'5b'5cd'5f'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5cd'5f'5d'2a'29'3f'5bfFL'5d'3fi'3f = compileRegex "\\.\\d[\\d_]*([eE][-+]?\\d[\\d_]*)?[fFL]?i?"
regex_'5cd = compileRegex "\\d"
regex_'5b'5ea'2dzA'2dZ'5f'5d = compileRegex "[^a-zA-Z_]"
regex_in'5cs'2a'28'3f'3d'5c'7b'29 = compileRegex "in\\s*(?=\\{)"
regex_out'5cs'2a'28'3f'3d'28'5c'28'28'5ba'2dzA'2dZ'5f'5d'5b'5cw'5f'5d'2a'29'3f'5c'29'5cs'2a'29'3f'5c'7b'29 = compileRegex "out\\s*(?=(\\(([a-zA-Z_][\\w_]*)?\\)\\s*)?\\{)"
regex_scope'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "scope\\s*(?=\\()"
regex_import'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "import\\s*(?=\\()"
regex_function'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "function\\s*(?=\\()"
regex_delegate'5cs'2a'28'3f'3d'5c'28'29 = compileRegex "delegate\\s*(?=\\()"
regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5f'5d'2a'28'5c'2e'5b'5cda'2dfA'2dF'5f'5d'2a'29'3f'5bpP'5d'5b'2d'2b'5d'3f'5cd'5b'5cd'5f'5d'2a'5bfFL'5d'3fi'3f = compileRegex "0[xX][\\da-fA-F_]*(\\.[\\da-fA-F_]*)?[pP][-+]?\\d[\\d_]*[fFL]?i?"
regex_'5cd'5b'5f'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5f'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5f'5cd'5d'2a'29'3f'5bfFL'5d'3fi'3f'7c'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5f'5cd'5d'2a'5bfFL'5d'3fi'3f'7c'5bfF'5di'3f'7c'5bfFL'5d'3fi'29 = compileRegex "\\d[_\\d]*(\\.(?!\\.)[_\\d]*([eE][-+]?\\d[_\\d]*)?[fFL]?i?|[eE][-+]?\\d[_\\d]*[fFL]?i?|[fF]i?|[fFL]?i)"
regex_0'5bbB'5d'5f'2a'5b01'5d'5b01'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f = compileRegex "0[bB]_*[01][01_]*(L[uU]?|[uU]L?)?"
regex_0'5b0'2d7'5f'5d'2b'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f = compileRegex "0[0-7_]+(L[uU]?|[uU]L?)?"
regex_0'5bxX'5d'5f'2a'5b'5cda'2dfA'2dF'5d'5b'5cda'2dfA'2dF'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f = compileRegex "0[xX]_*[\\da-fA-F][\\da-fA-F_]*(L[uU]?|[uU]L?)?"
regex_'5cd'2b'5b'5cd'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f = compileRegex "\\d+[\\d_]*(L[uU]?|[uU]L?)?"
regex_'28'280'28'5b0'2d7'5f'5d'2b'7c'5bbB'5d'5f'2a'5b01'5d'5b01'5f'5d'2a'7c'5bxX'5d'5f'2a'5b'5cda'2dfA'2dF'5d'5b'5cda'2dfA'2dF'5f'5d'2a'29'29'7c'5cd'2b'5b'5cd'5f'5d'2a'29'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f = compileRegex "((0([0-7_]+|[bB]_*[01][01_]*|[xX]_*[\\da-fA-F][\\da-fA-F_]*))|\\d+[\\d_]*)(L[uU]?|[uU]L?)?"
regex_'22'5b'5e'22'5d'2a'22 = compileRegex "\"[^\"]*\""
regex_'2e'2b = compileRegex ".+"
regex_'5b'5cda'2dfA'2dF'5d'7b4'7d = compileRegex "[\\da-fA-F]{4}"
regex_'5b'5cda'2dfA'2dF'5d'7b8'7d = compileRegex "[\\da-fA-F]{8}"
regex_'5ba'2dzA'2dZ'5d'5cw'2b'3b = compileRegex "[a-zA-Z]\\w+;"
regex_'5b'5e'5cs'5cw'2e'3a'2c'3d'5d = compileRegex "[^\\s\\w.:,=]"
regex_'5b'5e'29'5cs'5cn'5d'2b = compileRegex "[^)\\s\\n]+"
regex_'5b'5e'5cs'5cn'5d'2b = compileRegex "[^\\s\\n]+"
regex_'5b'5e'5csa'2dfA'2dF'5cd'22'5d'2b = compileRegex "[^\\sa-fA-F\\d\"]+"
regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 = compileRegex "\\\\(u[\\da-fA-F]{4}|U[\\da-fA-F]{8}|&[a-zA-Z]\\w+;)"
regex_'5c'5c'2e = compileRegex "\\\\."
regex_'2e = compileRegex "."
regex_'2f'7b3'2c'7d = compileRegex "/{3,}"
regex_'2f'5c'2a'7b2'2c'7d'28'3f'21'2f'29 = compileRegex "/\\*{2,}(?!/)"
regex_'2f'5c'2b'7b2'2c'7d'28'3f'21'2f'29 = compileRegex "/\\+{2,}(?!/)"
regex_'5b'5cw'5f'5d'2b'3a'28'24'7c'5cs'29 = compileRegex "[\\w_]+:($|\\s)"
regex_'5c'2a'2b'2f = compileRegex "\\*+/"
regex_'5b'5e'2d'5d'2d'7b3'2c'7d = compileRegex "[^-]-{3,}"
regex_'2d'7b3'2c'7d'28'24'7c'5cs'29 = compileRegex "-{3,}($|\\s)"
regex_'5c'2b'2b'2f = compileRegex "\\++/"

defaultAttributes = [("normal",NormalTok),("StartingLetter",NormalTok),("Properties",NormalTok),("NumberLiteral",NormalTok),("LinePragma",KeywordTok),("UnicodeShort",StringTok),("UnicodeLong",StringTok),("HTMLEntity",StringTok),("ModuleName",NormalTok),("Linkage",NormalTok),("Linkage2",NormalTok),("Version",NormalTok),("Version2",NormalTok),("Scope",NormalTok),("Scope2",NormalTok),("Pragma",KeywordTok),("Pragma2",KeywordTok),("RawString",StringTok),("BQString",StringTok),("HexString",StringTok),("CharLiteral",CharTok),("CharLiteralClosing",ErrorTok),("String",StringTok),("CommentRules",NormalTok),("Region Marker",RegionMarkerTok),("CommentLine",CommentTok),("CommentBlock",CommentTok),("CommentNested",CommentTok),("DdocNormal",NormalTok),("DdocLine",CommentTok),("DdocBlock",CommentTok),("DdocNested",CommentTok),("DdocNested2",CommentTok),("DdocMacro",ErrorTok),("DdocMacro2",NormalTok),("DdocMacro3",NormalTok),("MacroRules",NormalTok),("DdocBlockCode",NormalTok),("DdocNestedCode",NormalTok)]

parseRules "normal" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pRegExpr regex_'5ba'2dzA'2dZ'5f'5d) >> pushContext "StartingLetter" >> currentContext >>= parseRules))
   <|>
   ((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '\\' 'u' >>= withAttribute StringTok) >>~ pushContext "UnicodeShort")
   <|>
   ((pDetect2Chars False '\\' 'U' >>= withAttribute StringTok) >>~ pushContext "UnicodeLong")
   <|>
   ((pDetect2Chars False '\\' '&' >>= withAttribute StringTok) >>~ pushContext "HTMLEntity")
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext "CharLiteral")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext "BQString")
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext "Region Marker")
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext "Region Marker")
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pString False "..." >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '.' '.' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2e'5cd'5b'5cd'5f'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5cd'5f'5d'2a'29'3f'5bfFL'5d'3fi'3f >>= withAttribute FloatTok))
   <|>
   ((pDetectChar False '.' >>= withAttribute NormalTok) >>~ pushContext "Properties")
   <|>
   ((lookAhead (pRegExpr regex_'5cd) >> pushContext "NumberLiteral" >> currentContext >>= parseRules))
   <|>
   ((pString False "#line" >>= withAttribute KeywordTok) >>~ pushContext "LinePragma")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok)))

parseRules "StartingLetter" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pRegExpr regex_'5b'5ea'2dzA'2dZ'5f'5d) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_in'5cs'2a'28'3f'3d'5c'7b'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_out'5cs'2a'28'3f'3d'28'5c'28'28'5ba'2dzA'2dZ'5f'5d'5b'5cw'5f'5d'2a'29'3f'5c'29'5cs'2a'29'3f'5c'7b'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_scope'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute KeywordTok) >>~ pushContext "Scope")
   <|>
   ((pRegExpr regex_import'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_function'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_delegate'5cs'2a'28'3f'3d'5c'28'29 >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_statements >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attributes >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_expressions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_declarators >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_templates >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_modules >>= withAttribute KeywordTok) >>~ pushContext "ModuleName")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_libsymbols >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_linkage >>= withAttribute KeywordTok) >>~ pushContext "Linkage")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_specialtokens >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_tests >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_pragma >>= withAttribute KeywordTok) >>~ pushContext "Pragma")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_version >>= withAttribute KeywordTok) >>~ pushContext "Version")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_deprecated >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False 'r' '"' >>= withAttribute StringTok) >>~ pushContext "RawString")
   <|>
   ((pDetect2Chars False 'x' '"' >>= withAttribute StringTok) >>~ pushContext "HexString")
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_userkeywords >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok)))

parseRules "Properties" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_properties >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "NumberLiteral" =
  (((pRegExpr regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5f'5d'2a'28'5c'2e'5b'5cda'2dfA'2dF'5f'5d'2a'29'3f'5bpP'5d'5b'2d'2b'5d'3f'5cd'5b'5cd'5f'5d'2a'5bfFL'5d'3fi'3f >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cd'5b'5f'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5f'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5f'5cd'5d'2a'29'3f'5bfFL'5d'3fi'3f'7c'5beE'5d'5b'2d'2b'5d'3f'5cd'5b'5f'5cd'5d'2a'5bfFL'5d'3fi'3f'7c'5bfF'5di'3f'7c'5bfFL'5d'3fi'29 >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_0'5bbB'5d'5f'2a'5b01'5d'5b01'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_0'5b0'2d7'5f'5d'2b'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_0'5bxX'5d'5f'2a'5b'5cda'2dfA'2dF'5d'5b'5cda'2dfA'2dF'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cd'2b'5b'5cd'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "LinePragma" =
  (((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'280'28'5b0'2d7'5f'5d'2b'7c'5bbB'5d'5f'2a'5b01'5d'5b01'5f'5d'2a'7c'5bxX'5d'5f'2a'5b'5cda'2dfA'2dF'5d'5b'5cda'2dfA'2dF'5f'5d'2a'29'29'7c'5cd'2b'5b'5cd'5f'5d'2a'29'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'22'5b'5e'22'5d'2a'22 >>= withAttribute StringTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_specialtokens >>= withAttribute NormalTok))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pRegExpr regex_'2e'2b >>= withAttribute ErrorTok) >>~ (popContext)))

parseRules "UnicodeShort" =
  ((pRegExpr regex_'5b'5cda'2dfA'2dF'5d'7b4'7d >>= withAttribute StringTok) >>~ (popContext))

parseRules "UnicodeLong" =
  ((pRegExpr regex_'5b'5cda'2dfA'2dF'5d'7b8'7d >>= withAttribute StringTok) >>~ (popContext))

parseRules "HTMLEntity" =
  (((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2b'3b >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "ModuleName" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((lookAhead (pRegExpr regex_'5b'5e'5cs'5cw'2e'3a'2c'3d'5d) >> (popContext) >> currentContext >>= parseRules)))

parseRules "Linkage" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Linkage2")
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Linkage2" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "C++" >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_ltypes >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5b'5e'29'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext >> popContext)))

parseRules "Version" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '=' >>= withAttribute NormalTok) >>~ pushContext "Version2")
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Version2")
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pRegExpr regex_'5b'5e'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext)))

parseRules "Version2" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_vtypes >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cd'2b'5b'5cd'5f'5d'2a'28L'5buU'5d'3f'7c'5buU'5dL'3f'29'3f >>= withAttribute DecValTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5b'5e'29'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext >> popContext)))

parseRules "Scope" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Scope2")
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Scope2" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_scope'5fkeywords >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5b'5e'29'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext >> popContext)))

parseRules "Pragma" =
  (((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Pragma2")
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pRegExpr regex_'5b'5e'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext)))

parseRules "Pragma2" =
  (((pDetectSpaces >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_ptypes >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "CommentRules"))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5b'5e'29'5cs'5cn'5d'2b >>= withAttribute ErrorTok) >>~ (popContext >> popContext)))

parseRules "RawString" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "BQString" =
  ((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext))

parseRules "HexString" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b'5e'5csa'2dfA'2dF'5cd'22'5d'2b >>= withAttribute ErrorTok)))

parseRules "CharLiteral" =
  (((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute StringTok) >>~ pushContext "CharLiteralClosing")
   <|>
   ((pRegExpr regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 >>= withAttribute StringTok) >>~ pushContext "CharLiteralClosing")
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute ErrorTok) >>~ pushContext "CharLiteralClosing")
   <|>
   ((pRegExpr regex_'2e >>= withAttribute CharTok) >>~ pushContext "CharLiteralClosing")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "CharLiteralClosing" =
  (((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext >> popContext))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules "String" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetect2Chars False '"' 'c' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '"' 'w' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '"' 'd' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '\\' 'u' >>= withAttribute StringTok) >>~ pushContext "UnicodeShort")
   <|>
   ((pDetect2Chars False '\\' 'U' >>= withAttribute StringTok) >>~ pushContext "UnicodeLong")
   <|>
   ((pDetect2Chars False '\\' '&' >>= withAttribute StringTok) >>~ pushContext "HTMLEntity"))

parseRules "CommentRules" =
  (((parseRules "DdocNormal"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "CommentLine")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "CommentBlock")
   <|>
   ((pDetect2Chars False '/' '+' >>= withAttribute CommentTok) >>~ pushContext "CommentNested"))

parseRules "Region Marker" =
  pzero

parseRules "CommentLine" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "CommentBlock" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "CommentNested" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '/' '+' >>= withAttribute CommentTok) >>~ pushContext "CommentNested")
   <|>
   ((pDetect2Chars False '+' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "DdocNormal" =
  (((pRegExpr regex_'2f'7b3'2c'7d >>= withAttribute CommentTok) >>~ pushContext "DdocLine")
   <|>
   ((pRegExpr regex_'2f'5c'2a'7b2'2c'7d'28'3f'21'2f'29 >>= withAttribute CommentTok) >>~ pushContext "DdocBlock")
   <|>
   ((pRegExpr regex_'2f'5c'2b'7b2'2c'7d'28'3f'21'2f'29 >>= withAttribute CommentTok) >>~ pushContext "DdocNested"))

parseRules "DdocLine" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute OtherTok) >>~ pushContext "DdocMacro")
   <|>
   ((pRegExpr regex_'5b'5cw'5f'5d'2b'3a'28'24'7c'5cs'29 >>= withAttribute KeywordTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "DdocBlock" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5c'2a'2b'2f >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute OtherTok) >>~ pushContext "DdocMacro")
   <|>
   ((pRegExpr regex_'5b'5cw'5f'5d'2b'3a'28'24'7c'5cs'29 >>= withAttribute KeywordTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pRegExpr regex_'5b'5e'2d'5d'2d'7b3'2c'7d >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'2d'7b3'2c'7d'28'24'7c'5cs'29 >>= withAttribute CommentTok) >>~ pushContext "DdocBlockCode"))

parseRules "DdocNested" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '/' '+' >>= withAttribute CommentTok) >>~ pushContext "DdocNested2")
   <|>
   ((pRegExpr regex_'5c'2b'2b'2f >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pDetectChar False '+' >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute OtherTok) >>~ pushContext "DdocMacro")
   <|>
   ((pRegExpr regex_'5b'5cw'5f'5d'2b'3a'28'24'7c'5cs'29 >>= withAttribute KeywordTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pRegExpr regex_'5b'5e'2d'5d'2d'7b3'2c'7d >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'2d'7b3'2c'7d'28'24'7c'5cs'29 >>= withAttribute CommentTok) >>~ pushContext "DdocNestedCode"))

parseRules "DdocNested2" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5c'2b'2b'2f >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((parseRules "DdocNested")))

parseRules "DdocMacro" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules "MacroRules"))
   <|>
   ((pDetectIdentifier >>= withAttribute OtherTok) >>~ pushContext "DdocMacro2"))

parseRules "DdocMacro2" =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "MacroRules")))

parseRules "DdocMacro3" =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "MacroRules")))

parseRules "MacroRules" =
  (((pDetect2Chars False '$' '(' >>= withAttribute OtherTok) >>~ pushContext "DdocMacro")
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "DdocMacro3")
   <|>
   ((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute CommentTok)))

parseRules "DdocBlockCode" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2a'2b'2f >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   ((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5b'5e'2d'5d'2d'7b3'2c'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'7b3'2c'7d'28'24'7c'5cs'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.D.parseExpression)))

parseRules "DdocNestedCode" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2b'2b'2f >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   ((pFirstNonSpace >> pDetectChar False '+' >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5b'5e'2d'5d'2d'7b3'2c'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'7b3'2c'7d'28'24'7c'5cs'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.D.parseExpression)))

parseRules "" = parseRules "normal"

parseRules x = fail $ "Unknown context" ++ x
