{- This module was generated from data in the Kate syntax
   highlighting file r.xml, version 2.04, by  -}

module Text.Highlighting.Kate.Syntax.R
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "R Script"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.R;*.r;*.S;*.s;*.q"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "R Script" }
  context <- currentContext <|> (pushContext "level0" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("R Script",["level0"])], synStLanguage = "R Script", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "level0" -> return ()
    "ctx0" -> return ()
    "parenthesis" -> return ()
    "string" -> return ()
    "string2" -> return ()
    "backquotedsymbol" -> return ()
    "Headline" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    "CommonRules" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_controls = Set.fromList $ words $ "for in next break while repeat if else switch function"
list_words = Set.fromList $ words $ "TRUE FALSE NULL NA NA_integer_ NA_real_ NA_complex_ NA_character_ Inf NaN"

regex_'5ba'2dzA'2dZ'5f'5c'2e'5d'5b0'2d9a'2dzA'2dZ'5f'5c'2e'5d'2a'5b'5cs'5d'2a'3d'28'3f'3d'28'5b'5e'3d'5d'7c'24'29'29 = compileRegex "[a-zA-Z_\\.][0-9a-zA-Z_\\.]*[\\s]*=(?=([^=]|$))"
regex_'5ba'2dzA'2dZ'5f'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex "[a-zA-Z_]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
regex_'5c'2e'5ba'2dzA'2dZ'5f'5c'2e'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex "\\.[a-zA-Z_\\.]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
regex_'5c'28 = compileRegex "\\("
regex_'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'26'5c'7c'3d'3e'40'5e'5d'29'28'5b'3c'5d'7b1'2c2'7d'5c'2d'7c'5c'2d'5b'3e'5d'7b1'2c2'7d'29 = compileRegex "([\\+\\-\\*/\\^\\:\\$~!&\\|=>@^])([<]{1,2}\\-|\\-[>]{1,2})"
regex_'28'5b'3c'5d'7b1'2c2'7d'5c'2d'7c'5c'2d'5b'3e'5d'7b1'2c2'7d'29'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'26'5c'7c'3d'3c'40'5d'29 = compileRegex "([<]{1,2}\\-|\\-[>]{1,2})([\\+\\-\\*/\\^\\:\\$~!&\\|=<@])"
regex_'28'5b'3c'5d'7b3'7d'7c'5b'3e'5d'7b3'7d'29 = compileRegex "([<]{3}|[>]{3})"
regex_'5b'3c'5d'7b1'2c2'7d'5c'2d = compileRegex "[<]{1,2}\\-"
regex_'5c'2d'5b'3e'5d'7b1'2c2'7d = compileRegex "\\-[>]{1,2}"
regex_'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'26'5c'7c'40'5e'5d'29'3d = compileRegex "([\\+\\-\\*/\\^\\:\\$~&\\|@^])="
regex_'3d'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'3c'3e'26'5c'7c'40'5e'5d'29 = compileRegex "=([\\+\\-\\*/\\^\\:\\$~!<>&\\|@^])"
regex_'3d'28'3f'21'3d'29 = compileRegex "=(?!=)"
regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7b1'2c2'7d'7c'5c'21'3d'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'28'28'3f'21'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7c'5c'21'3d'7c'5c'7c'7c'26'7c'3a'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'29'7c'24'29 = compileRegex "(\\+|\\-|\\*|/|<=|>=|={1,2}|\\!=|\\|{1,2}|&{1,2}|:{1,3}|\\^|@|\\$|~)((?!(\\+|\\-|\\*|/|<=|>=|=|\\!=|\\||&|:|\\^|@|\\$|~))|$)"
regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7b1'2c2'7d'7c'5c'21'3d'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'7b2'2c'7d = compileRegex "(\\+|\\-|\\*|/|<=|>=|={1,2}|\\!=|\\|{1,2}|&{1,2}|:{1,3}|\\^|@|\\$|~){2,}"
regex_'25'5b'5e'25'5d'2a'25 = compileRegex "%[^%]*%"

defaultAttributes = [("level0",NormalTok),("ctx0",NormalTok),("parenthesis",NormalTok),("string",StringTok),("string2",StringTok),("backquotedsymbol",DataTypeTok),("Headline",NormalTok),("Comment",CommentTok),("CommonRules",NormalTok)]

parseRules "level0" =
  (((parseRules "CommonRules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute ErrorTok)))

parseRules "ctx0" =
  (((parseRules "CommonRules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute ErrorTok)))

parseRules "parenthesis" =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5c'2e'5d'5b0'2d9a'2dzA'2dZ'5f'5c'2e'5d'2a'5b'5cs'5d'2a'3d'28'3f'3d'28'5b'5e'3d'5d'7c'24'29'29 >>= withAttribute DataTypeTok))
   <|>
   ((parseRules "CommonRules"))
   <|>
   ((pDetectChar False '}' >>= withAttribute ErrorTok)))

parseRules "string" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok)))

parseRules "string2" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok)))

parseRules "backquotedsymbol" =
  (((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok)))

parseRules "Headline" =
  pzero

parseRules "Comment" =
  pzero

parseRules "CommonRules" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "string")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "string2")
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext "backquotedsymbol")
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\$" list_controls >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\$" list_words >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'2e'5ba'2dzA'2dZ'5f'5c'2e'5d'2b'5ba'2dzA'2dZ'5f'5c'2e0'2d9'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5c'28 >>= withAttribute NormalTok) >>~ pushContext "parenthesis")
   <|>
   ((pString False "##" >>= withAttribute NormalTok) >>~ pushContext "Headline")
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'26'5c'7c'3d'3e'40'5e'5d'29'28'5b'3c'5d'7b1'2c2'7d'5c'2d'7c'5c'2d'5b'3e'5d'7b1'2c2'7d'29 >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'28'5b'3c'5d'7b1'2c2'7d'5c'2d'7c'5c'2d'5b'3e'5d'7b1'2c2'7d'29'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'26'5c'7c'3d'3c'40'5d'29 >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'28'5b'3c'5d'7b3'7d'7c'5b'3e'5d'7b3'7d'29 >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'5b'3c'5d'7b1'2c2'7d'5c'2d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2d'5b'3e'5d'7b1'2c2'7d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'26'5c'7c'40'5e'5d'29'3d >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'3d'28'5b'5c'2b'5c'2d'5c'2a'2f'5c'5e'5c'3a'5c'24'7e'21'3c'3e'26'5c'7c'40'5e'5d'29 >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'3d'28'3f'21'3d'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7b1'2c2'7d'7c'5c'21'3d'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'28'28'3f'21'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7c'5c'21'3d'7c'5c'7c'7c'26'7c'3a'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'29'7c'24'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5c'2b'7c'5c'2d'7c'5c'2a'7c'2f'7c'3c'3d'7c'3e'3d'7c'3d'7b1'2c2'7d'7c'5c'21'3d'7c'5c'7c'7b1'2c2'7d'7c'26'7b1'2c2'7d'7c'3a'7b1'2c3'7d'7c'5c'5e'7c'40'7c'5c'24'7c'7e'29'7b2'2c'7d >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'25'5b'5e'25'5d'2a'25 >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "ctx0")
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok)))

parseRules "" = parseRules "level0"

parseRules x = fail $ "Unknown context" ++ x
