#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoItalianoMod :public Plugin{
public:
  dsoItalianoMod();
  virtual void Init();
private:
  static void DAYNAME(__HITOPFUNC__);
  static void MONTHNAME(__HITOPFUNC__);
  static void DAYSHORTNAME(__HITOPFUNC__);
  static void MONTHSHORTNAME(__HITOPFUNC__);
  static void DAYABBREV(__HITOPFUNC__);
  static void MONTHABBREV(__HITOPFUNC__);
};

static dsoItalianoMod initmodule;

static const string daynames[]={"domenica","luned&iacute;","marted&iacute;",
  "mercoled&iacute;","gioved&iacute;","venerd&iacute;","sabato"};
static const string monthnames[]={"gennaio","febbraio","marzo","aprile",
  "maggio","giugno","luglio","agosto","settembre","ottobre","novembre",
  "dicembre"};
static const string dayshortnames[]={"dom","lun","mar","mer","gio","ven",
  "sab"};
static const string monthshortnames[]={"gen","feb","mar","apr","mag","giu",
  "lug","ago","set","ott","nov","dic"};
static const string dayabbrevs[]={"d","l","ma","me","g","v","s"};
static const string monthabbrevs[]={"ge","f","mr","ap","mg","gi","l","a","s",
  "o","n","d"};

dsoItalianoMod::dsoItalianoMod() {
  RegisterPlugin(string("italiano"),1);
}

void dsoItalianoMod::Init(){
  SetNamespace("ITALIANO");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoItalianoMod::DAYNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[data.AsInt()%7];
}

void dsoItalianoMod::MONTHNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(data.AsInt()-1)%12];
}

void dsoItalianoMod::DAYSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[data.AsInt()%7];
}

void dsoItalianoMod::MONTHSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(data.AsInt()-1)%12];
}

void dsoItalianoMod::DAYABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[data.AsInt()%7];
}

void dsoItalianoMod::MONTHABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(data.AsInt()-1)%12];
}
