/*
 *	HT Editor
 *	alphaopc.cc
 *
 *	Copyright (C) 1999-2002 Sebastian Biallas (sb@biallas.net)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "alphaopc.h"

char *alpha_reg_names[] = {
/*     0 */ "v0",
/*  1- 8 */ "t0","t1","t2","t3","t4","t5","t6","t7",
/*  9-15 */ "s0","s1","s2","s3","s4","s5","s6/fp",
/* 16-21 */ "a0","a1","a2","a3","a4","a5",
/* 22-25 */ "t8","t9","t10","t11",
/* 26-31 */ "ra","t12/pv","at","gp","sp","zero",
/* 32-39 */ "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7",
/* 40-47 */ "f8", "f9", "f10","f11","f12","f13","f14","f15",
/* 48-55 */ "f16","f17","f18","f19","?",  "?",  "?",  "?",
/* 56-64 */ "?",  "?",  "?",  "?",  "?",  "?",  "?",  "fzero", "lit"
};


alpha_opcode_tab_entry alpha_instr_tbl[] =
{
	{0x00,"call_pal",	ALPHA_GROUP_PAL},
	{0x01,"opcode01",	ALPHA_ERROR},
	{0x02,"opcode02",	ALPHA_ERROR},
	{0x03,"opcode03",	ALPHA_ERROR},
	{0x04,"opcode04",	ALPHA_ERROR},
	{0x05,"opcode05",	ALPHA_ERROR},
	{0x06,"opcode06",	ALPHA_ERROR},
	{0x07,"opcode07",	ALPHA_ERROR},

	{0x08,"lda",		ALPHA_GROUP3},
	{0x09,"ldah",		ALPHA_GROUP3},
	{0x0a,"ldbu",		ALPHA_GROUP3},
	{0x0b,"ldq_u",		ALPHA_GROUP3},
	{0x0c,"ldwu",		ALPHA_GROUP3},
	{0x0d,"stw",		ALPHA_GROUP4},
	{0x0e,"stb",		ALPHA_GROUP4},
	{0x0f,"stq_u",		ALPHA_GROUP4},

	{0x10,"opcode10",	ALPHA_EXTENSION_10},
	{0x11,"opcode11",	ALPHA_EXTENSION_11},
	{0x12,"opcode12",	ALPHA_EXTENSION_12},
	{0x13,"opcode13",	ALPHA_EXTENSION_13},
	{0x14,"opcode14",	ALPHA_EXTENSION_14},
	{0x15,"opcode15",	ALPHA_EXTENSION_15},
	{0x16,"opcode16",	ALPHA_EXTENSION_16},
	{0x17,"opcode17",	ALPHA_EXTENSION_17},

	{0x18,"opcode18",	ALPHA_EXTENSION_18},
	{0x19,"pal19",		ALPHA_ERROR},
	{0x1a,"opcode1a",	ALPHA_EXTENSION_1A},
	{0x1b,"pal1b",		ALPHA_ERROR},
	{0x1c,"opcode1c",	ALPHA_EXTENSION_1C},
	{0x1d,"pal1d",		ALPHA_ERROR},
	{0x1e,"pal1e",		ALPHA_ERROR},
	{0x1f,"pal1f",		ALPHA_ERROR},
    
	{0x20,"ldf",		ALPHA_GROUP_FLD},
	{0x21,"ldg",		ALPHA_GROUP_FLD},
	{0x22,"lds",		ALPHA_GROUP_FLD},
	{0x23,"ldt",		ALPHA_GROUP_FLD},
	{0x24,"stf",		ALPHA_GROUP_FST},
	{0x25,"stg",		ALPHA_GROUP_FST},
	{0x26,"sts",		ALPHA_GROUP_FST},
	{0x27,"stt",		ALPHA_GROUP_FST},
    
	{0x28,"ldl",		ALPHA_GROUP3},
	{0x29,"ldq",		ALPHA_GROUP3},
	{0x2a,"ldl_l",		ALPHA_GROUP3},
	{0x2b,"ldq_l",		ALPHA_GROUP3},
	{0x2c,"stl",		ALPHA_GROUP4},
	{0x2d,"stq",		ALPHA_GROUP4},
	{0x2e,"stl_c",		ALPHA_GROUP4},
	{0x2f,"stq_c",		ALPHA_GROUP4},

	{0x30,"br",		ALPHA_GROUP_BRA},
	{0x31,"fbeq",		ALPHA_GROUP_FBR},
	{0x32,"fblt",		ALPHA_GROUP_FBR},
	{0x33,"fble",		ALPHA_GROUP_FBR},
	{0x34,"bsr",		ALPHA_GROUP_BRA},
	{0x35,"fbne",		ALPHA_GROUP_FBR},
	{0x36,"fbge",		ALPHA_GROUP_FBR},
	{0x37,"fbgt",		ALPHA_GROUP_FBR},
    
	{0x38,"blbc",		ALPHA_GROUP_BRA},
	{0x39,"beq",		ALPHA_GROUP_BRA},
	{0x3a,"blt",		ALPHA_GROUP_BRA},
	{0x3b,"ble",		ALPHA_GROUP_BRA},
	{0x3c,"blbs",		ALPHA_GROUP_BRA},
	{0x3d,"bne",		ALPHA_GROUP_BRA},
	{0x3e,"bge",		ALPHA_GROUP_BRA},
	{0x3f,"bgt",		ALPHA_GROUP_BRA}
};

/* table10 */
alpha_opcode_tab_entry alpha_instr_tbl_ext10[] =
{
	{0x00,"addl",		ALPHA_GROUP1},
	{0x02,"s4addl",	ALPHA_GROUP1},
	{0x09,"subl",		ALPHA_GROUP1},
	{0x0b,"s4subl",	ALPHA_GROUP1},
	{0x0f,"cmpbge",	ALPHA_GROUP1},
	{0x12,"s8addl",	ALPHA_GROUP1},
	{0x1b,"s8subl",	ALPHA_GROUP1},
	{0x1d,"cmpult",	ALPHA_GROUP1},
	{0x20,"addq",		ALPHA_GROUP1},
	{0x22,"s4addq",	ALPHA_GROUP1},
	{0x29,"subq",		ALPHA_GROUP1},
	{0x2b,"s4subq",	ALPHA_GROUP1},
	{0x2d,"cmpeq",		ALPHA_GROUP1},
	{0x32,"s8addq",	ALPHA_GROUP1},
	{0x3b,"s8subq",	ALPHA_GROUP1},
	{0x3d,"cmpule",	ALPHA_GROUP1},
	{0x40,"addl/v",	ALPHA_GROUP1},
	{0x49,"subl/v",	ALPHA_GROUP1},
	{0x4d,"cmplt",		ALPHA_GROUP1},
	{0x60,"addq/v",	ALPHA_GROUP1},
	{0x69,"subq/v",	ALPHA_GROUP1},
	{0x6d,"cmple",		ALPHA_GROUP1},
	{0xff,"",			ALPHA_ERROR}
};

/* table11 */
alpha_opcode_tab_entry alpha_instr_tbl_ext11[] =
{
	{0x00,"and",		ALPHA_GROUP1},
	{0x08,"bic",		ALPHA_GROUP1},
	{0x14,"cmovlbs",	ALPHA_GROUP1},
	{0x16,"cmovlbc",	ALPHA_GROUP1},
	{0x20,"bis",		ALPHA_GROUP1},
	{0x24,"cmoveq",	ALPHA_GROUP1},
	{0x26,"cmovne",	ALPHA_GROUP1},
	{0x28,"ornot",		ALPHA_GROUP1},
	{0x40,"xor",		ALPHA_GROUP1},
	{0x44,"cmovlt",	ALPHA_GROUP1},
	{0x46,"cmovge",	ALPHA_GROUP1},
	{0x48,"eqv",		ALPHA_GROUP1},
	{0x61,"amask",		ALPHA_GROUP3},
	{0x64,"cmovle",	ALPHA_GROUP1},
	{0x66,"cmovgt",	ALPHA_GROUP1},
	{0x6c,"implver",	ALPHA_GROUP3},
	{0xff,"",			ALPHA_ERROR}
};

/* table12 */
alpha_opcode_tab_entry alpha_instr_tbl_ext12[] =
{
	{0x00,"",			ALPHA_ERROR},
	{0x02,"mskbl",		ALPHA_GROUP1},
	{0x06,"extbl",		ALPHA_GROUP1},
	{0x0b,"insbl",		ALPHA_GROUP1},
	{0x12,"mskwl",		ALPHA_GROUP1},
	{0x16,"extwl",		ALPHA_GROUP1},
	{0x1b,"inswl",		ALPHA_GROUP1},
	{0x22,"mskll",		ALPHA_GROUP1},
	{0x26,"extll",		ALPHA_GROUP1},
	{0x2b,"insll",		ALPHA_GROUP1},
	{0x30,"zap",		ALPHA_GROUP1},
	{0x31,"zapnot",	ALPHA_GROUP1},
	{0x32,"mskql",		ALPHA_GROUP1},
	{0x34,"srl",		ALPHA_GROUP1},
	{0x36,"extql",		ALPHA_GROUP1},
	{0x39,"sll",		ALPHA_GROUP1},
	{0x3b,"insql",		ALPHA_GROUP1},
	{0x3c,"sra",		ALPHA_GROUP1},
	{0x52,"mskwh",		ALPHA_GROUP1},
	{0x57,"inswh",		ALPHA_GROUP1},
	{0x5a,"extwh",		ALPHA_GROUP1},
	{0x62,"msklh",		ALPHA_GROUP1},
	{0x67,"inslh",		ALPHA_GROUP1},
	{0x6a,"extlh",		ALPHA_GROUP1},
	{0x72,"mskqh",		ALPHA_GROUP1},
	{0x77,"insqh",		ALPHA_GROUP1},
	{0x7a,"extqh",		ALPHA_GROUP1},
	{0xff,"",			ALPHA_ERROR}
};

/* table13 */
alpha_opcode_tab_entry alpha_instr_tbl_ext13[] =
{
	{0x00,"mull",		ALPHA_GROUP1},
	{0x20,"mulq",		ALPHA_GROUP1},
	{0x30,"umulh",		ALPHA_GROUP1},
	{0x40,"mull/v",	ALPHA_GROUP1},
	{0x60,"mulq/v",	ALPHA_GROUP1},
	{0xff,"",			ALPHA_ERROR}
};

/* table14 */
alpha_opcode_tab_entry alpha_instr_tbl_ext14[] =
{
	{0x000,"",		ALPHA_ERROR},
	{0x004,"itofs",	ALPHA_GROUP_I2F},
	{0x00a,"sqrtf/c",	ALPHA_ERROR},
	{0x00b,"sqrts/c",	ALPHA_ERROR},
	{0x014,"itoff",	ALPHA_GROUP_I2F},
	{0x024,"itoft",	ALPHA_GROUP_I2F},
	{0x02a,"sqrtg/c",	ALPHA_ERROR},
	{0x02b,"sqrtt/c",	ALPHA_ERROR},
	{0x04b,"sqrts/m",	ALPHA_ERROR},
	{0x06b,"sqrtt/m",	ALPHA_ERROR},
	{0x08a,"sqrtf",	ALPHA_ERROR},
	{0x08b,"sqrts",	ALPHA_ERROR},
	{0x0aa,"sqrtg",	ALPHA_ERROR},
	{0x0ab,"sqrtt",	ALPHA_ERROR},
	{0x0cb,"sqrts/d",	ALPHA_ERROR},
	{0x0eb,"sqrtt/d",	ALPHA_ERROR},
	{0x10a,"sqrtf/uc",	ALPHA_ERROR},
	{0x10b,"sqrts/uc",	ALPHA_ERROR},
	{0x12a,"sqrtg/uc",	ALPHA_ERROR},
	{0x12b,"sqrtt/uc",	ALPHA_ERROR},
	{0x14b,"sqrts/um",	ALPHA_ERROR},
	{0x16b,"sqrtt/um",	ALPHA_ERROR},
	{0x18a,"sqrtf/u",	ALPHA_ERROR},
	{0x18b,"sqrts/u",	ALPHA_ERROR},
	{0x1aa,"sqrtg/u",	ALPHA_ERROR},
	{0x1ab,"sqrtt/u",	ALPHA_ERROR},
	{0x1cb,"sqrts/ud",	ALPHA_ERROR},
	{0x1eb,"sqrtt/ud",	ALPHA_ERROR},
	{0x40a,"sqrtf/sc",	ALPHA_ERROR},
	{0x42a,"sqrtg/sc",	ALPHA_ERROR},
	{0x48a,"sqrtf/s",	ALPHA_ERROR},
	{0x4aa,"sqrtg/s",	ALPHA_ERROR},
	{0x50a,"sqrtf/suc",	ALPHA_ERROR},
	{0x50b,"sqrts/suc",	ALPHA_ERROR},
	{0x52a,"sqrtg/suc",	ALPHA_ERROR},
	{0x52b,"sqrtt/suc",	ALPHA_ERROR},
	{0x54b,"sqrts/sum",	ALPHA_ERROR},
	{0x56b,"sqrtt/sum",	ALPHA_ERROR},
	{0x58a,"sqrtf/su",	ALPHA_ERROR},
	{0x58b,"sqrts/su",	ALPHA_ERROR},
	{0x5aa,"sqrtg/su",	ALPHA_ERROR},
	{0x5ab,"sqrtt/su",	ALPHA_ERROR},
	{0x5cb,"sqrts/sud",	ALPHA_ERROR},
	{0x5eb,"sqrtt/sud",	ALPHA_ERROR},
	{0x70b,"sqrts/suic",ALPHA_ERROR},
	{0x72b,"sqrtt/suic",ALPHA_ERROR},
	{0x74b,"sqrts/suim",ALPHA_ERROR},
	{0x76b,"sqrtt/suim",ALPHA_ERROR},
	{0x78b,"sqrts/sui",	ALPHA_ERROR},
	{0x7ab,"sqrtt/sui",	ALPHA_ERROR},
	{0x7cb,"sqrts/suid",ALPHA_ERROR},
	{0x7eb,"sqrtt/suid",ALPHA_ERROR},
	{0xfff,"",		ALPHA_ERROR}
};

/* table15 */
alpha_opcode_tab_entry alpha_instr_tbl_ext15[] =
{
	{0x000,"addf/c",	ALPHA_GROUP2},
	{0x001,"subf/c",	ALPHA_GROUP2},
	{0x002,"mulf/c",	ALPHA_GROUP2},
	{0x003,"divf/c",	ALPHA_GROUP2},
	{0x01e,"cvtdg/c",	ALPHA_GROUP2},
	{0x020,"addg/c",	ALPHA_GROUP2},
	{0x021,"subg/c",	ALPHA_GROUP2},
	{0x022,"mulg/c",	ALPHA_GROUP2},
	{0x023,"divg/c",	ALPHA_GROUP2},
	{0x02c,"cvtgf/c",	ALPHA_GROUP2},
	{0x02d,"cvtgd/c",	ALPHA_GROUP2},
	{0x02f,"cvtgq/c",	ALPHA_GROUP2},
	{0x03c,"cvtqf/c",	ALPHA_GROUP2},
	{0x03e,"cvtqg/c",	ALPHA_GROUP2},
	{0x080,"addf",		ALPHA_GROUP2},
	{0x081,"subf",		ALPHA_GROUP2},
	{0x082,"mulf",		ALPHA_GROUP2},
	{0x083,"divf",		ALPHA_GROUP2},
	{0x09e,"cvtdg",	ALPHA_GROUP2},
	{0x0a0,"addg",		ALPHA_GROUP2},
	{0x0a1,"subg",		ALPHA_GROUP2},
	{0x0a2,"mulg",		ALPHA_GROUP2},
	{0x0a3,"divg",		ALPHA_GROUP2},
	{0x0a5,"cmpgeq",	ALPHA_GROUP2},
	{0x0a6,"cmpglt",	ALPHA_GROUP2},
	{0x0a7,"cmpgle",	ALPHA_GROUP2},
	{0x0ac,"cvtgf",	ALPHA_GROUP2},
	{0x0ad,"cvtgd",	ALPHA_GROUP2},
	{0x0af,"cvtgq",	ALPHA_GROUP2},
	{0x0bc,"cvtqf",	ALPHA_GROUP2},
	{0x0be,"cvtqg",	ALPHA_GROUP2},
	{0x100,"addf/uc",	ALPHA_GROUP2},
	{0x101,"subf/uc",	ALPHA_GROUP2},
	{0x102,"mulf/uc",	ALPHA_GROUP2},
	{0x103,"divf/uc",	ALPHA_GROUP2},
	{0x11e,"cvtdg/uc",	ALPHA_GROUP2},
	{0x120,"addg/uc",	ALPHA_GROUP2},
	{0x121,"subg/uc",	ALPHA_GROUP2},
	{0x122,"mulg/uc",	ALPHA_GROUP2},
	{0x123,"divg/uc",	ALPHA_GROUP2},
	{0x12c,"cvtgf/uc",	ALPHA_GROUP2},
	{0x12d,"cvtgd/uc",	ALPHA_GROUP2},
	{0x12f,"cvtgq/vc",	ALPHA_GROUP2},
	{0x180,"addf/u",	ALPHA_GROUP2},
	{0x181,"subf/u",	ALPHA_GROUP2},
	{0x182,"mulf/u",	ALPHA_GROUP2},
	{0x183,"divf/u",	ALPHA_GROUP2},
	{0x19e,"cvtdg/u",	ALPHA_GROUP2},
	{0x1a0,"addg/u",	ALPHA_GROUP2},
	{0x1a1,"subg/u",	ALPHA_GROUP2},
	{0x1a2,"mulg/u",	ALPHA_GROUP2},
	{0x1a3,"divg/u",	ALPHA_GROUP2},
	{0x1ac,"cvtgf/u",	ALPHA_GROUP2},
	{0x1ad,"cvtgd/u",	ALPHA_GROUP2},
	{0x1af,"cvtgq/v",	ALPHA_GROUP2},
	{0x400,"addf/sc",	ALPHA_GROUP2},
	{0x401,"subf/sc",	ALPHA_GROUP2},
	{0x402,"mulf/sc",	ALPHA_GROUP2},
	{0x403,"divf/sc",	ALPHA_GROUP2},
	{0x41e,"cvtdg/sc",	ALPHA_GROUP2},
	{0x420,"addg/sc",	ALPHA_GROUP2},
	{0x421,"subg/sc",	ALPHA_GROUP2},
	{0x422,"mulg/sc",	ALPHA_GROUP2},
	{0x423,"divg/sc",	ALPHA_GROUP2},
	{0x42c,"cvtgf/sc",	ALPHA_GROUP2},
	{0x42d,"cvtgd/sc",	ALPHA_GROUP2},
	{0x42f,"cvtgq/sc",	ALPHA_GROUP2},
	{0x480,"addf/s",	ALPHA_GROUP2},
	{0x481,"subf/s",	ALPHA_GROUP2},
	{0x482,"mulf/s",	ALPHA_GROUP2},
	{0x483,"divf/s",	ALPHA_GROUP2},
	{0x49e,"cvtdg/s",	ALPHA_GROUP2},
	{0x4a0,"addg/s",	ALPHA_GROUP2},
	{0x4a1,"subg/s",	ALPHA_GROUP2},
	{0x4a2,"mulg/s",	ALPHA_GROUP2},
	{0x4a3,"divg/s",	ALPHA_GROUP2},
	{0x4a5,"cmpgeq/s",	ALPHA_GROUP2},
	{0x4a6,"cmpglt/s",	ALPHA_GROUP2},
	{0x4a7,"cmpgle/s",	ALPHA_GROUP2},
	{0x4ac,"cvtgf/s",	ALPHA_GROUP2},
	{0x4ad,"cvtgd/s",	ALPHA_GROUP2},
	{0x4af,"cvtgq/s",	ALPHA_GROUP2},
	{0x500,"addf/suc",	ALPHA_GROUP2},
	{0x501,"subf/suc",	ALPHA_GROUP2},
	{0x502,"mulf/suc",	ALPHA_GROUP2},
	{0x503,"divf/suc",	ALPHA_GROUP2},
	{0x51e,"cvtdg/suc",	ALPHA_GROUP2},
	{0x520,"addg/suc",	ALPHA_GROUP2},
	{0x521,"subg/suc",	ALPHA_GROUP2},
	{0x522,"mulg/suc",	ALPHA_GROUP2},
	{0x523,"divg/suc",	ALPHA_GROUP2},
	{0x52c,"cvtgf/suc",	ALPHA_GROUP2},
	{0x52d,"cvtgd/suc",	ALPHA_GROUP2},
	{0x52f,"cvtgq/svc",	ALPHA_GROUP2},
	{0x580,"addf/su",	ALPHA_GROUP2},
	{0x581,"subf/su",	ALPHA_GROUP2},
	{0x582,"mulf/su",	ALPHA_GROUP2},
	{0x583,"divf/su",	ALPHA_GROUP2},
	{0x59e,"cvtdg/su",	ALPHA_GROUP2},
	{0x5a0,"addg/su",	ALPHA_GROUP2},
	{0x5a1,"subg/su",	ALPHA_GROUP2},
	{0x5a2,"mulg/su",	ALPHA_GROUP2},
	{0x5a3,"divg/su",	ALPHA_GROUP2},
	{0x5ac,"cvtgf/su",	ALPHA_GROUP2},
	{0x5ad,"cvtgd/su",	ALPHA_GROUP2},
	{0x5af,"cvtgq/sv",	ALPHA_GROUP2},
	{0xfff,"",		ALPHA_ERROR}
};

/* table16 */ 
alpha_opcode_tab_entry alpha_instr_tbl_ext16[] =
{
	{0x000,"adds/c",	ALPHA_GROUP2},
	{0x001,"subs/c",	ALPHA_GROUP2},
	{0x002,"muls/c",	ALPHA_GROUP2},
	{0x003,"divs/c",	ALPHA_GROUP2},
	{0x020,"addt/c",	ALPHA_GROUP2},
	{0x021,"subt/c",	ALPHA_GROUP2},
	{0x022,"mult/c",	ALPHA_GROUP2},
	{0x023,"divt/c",	ALPHA_GROUP2},
	{0x02c,"cvtts/c",	ALPHA_GROUP2},
	{0x02f,"cvttq/c",	ALPHA_GROUP2},
	{0x03c,"cvtqs/c",	ALPHA_GROUP2},
	{0x03e,"cvtqt/c",	ALPHA_GROUP2},
	{0x040,"adds/m",	ALPHA_GROUP2},
	{0x041,"subs/m",	ALPHA_GROUP2},
	{0x042,"muls/m",	ALPHA_GROUP2},
	{0x043,"divs/m",	ALPHA_GROUP2},
	{0x060,"addt/m",	ALPHA_GROUP2},
	{0x061,"subt/m",	ALPHA_GROUP2},
	{0x062,"mult/m",	ALPHA_GROUP2},
	{0x063,"divt/m",	ALPHA_GROUP2},
	{0x06c,"cvtts/m",	ALPHA_GROUP2},
	{0x06f,"cvttq/m",	ALPHA_GROUP2},
	{0x07c,"cvtqs/m",	ALPHA_GROUP2},
	{0x07e,"cvtqt/m",	ALPHA_GROUP2},
	{0x080,"adds",		ALPHA_GROUP2},
	{0x081,"subs",		ALPHA_GROUP2},
	{0x082,"muls",		ALPHA_GROUP2},
	{0x083,"divs",		ALPHA_GROUP2},
	{0x0a0,"addt",		ALPHA_GROUP2},
	{0x0a1,"subt",		ALPHA_GROUP2},
	{0x0a2,"mult",		ALPHA_GROUP2},
	{0x0a3,"divt",		ALPHA_GROUP2},
	{0x0a4,"cmptun",	ALPHA_GROUP2},
	{0x0a5,"cmpteq",	ALPHA_GROUP2},
	{0x0a6,"cmptlt",	ALPHA_GROUP2},
	{0x0a7,"cmptle",	ALPHA_GROUP2},
	{0x0ac,"cvtts",	ALPHA_GROUP2},
	{0x0af,"cvttq",	ALPHA_GROUP2},
	{0x0bc,"cvtqs",	ALPHA_GROUP2},
	{0x0be,"cvtqt",	ALPHA_GROUP2},
	{0x0c0,"adds/d",	ALPHA_GROUP2},
	{0x0c1,"subs/d",	ALPHA_GROUP2},
	{0x0c2,"muls/d",	ALPHA_GROUP2},
	{0x0c3,"divs/d",	ALPHA_GROUP2},
	{0x0e0,"addt/d",	ALPHA_GROUP2},
	{0x0e1,"subt/d",	ALPHA_GROUP2},
	{0x0e2,"mult/d",	ALPHA_GROUP2},
	{0x0e3,"divt/d",	ALPHA_GROUP2},
	{0x0ec,"cvtts/d",	ALPHA_GROUP2},
	{0x0ef,"cvttq/d",	ALPHA_GROUP2},
	{0x0fc,"cvtqs/d",	ALPHA_GROUP2},
	{0x0fe,"cvtqt/d",	ALPHA_GROUP2},
	{0x100,"adds/uc",	ALPHA_GROUP2},
	{0x101,"subs/uc",	ALPHA_GROUP2},
	{0x102,"muls/uc",	ALPHA_GROUP2},
	{0x103,"divs/uc",	ALPHA_GROUP2},
	{0x120,"addt/uc",	ALPHA_GROUP2},
	{0x121,"subt/uc",	ALPHA_GROUP2},
	{0x122,"mult/uc",	ALPHA_GROUP2},
	{0x123,"divt/uc",	ALPHA_GROUP2},
	{0x12c,"cvtts/uc",	ALPHA_GROUP2},
	{0x12f,"cvttq/vc",	ALPHA_GROUP2},
	{0x140,"adds/um",	ALPHA_GROUP2},
	{0x141,"subs/um",	ALPHA_GROUP2},
	{0x142,"muls/um",	ALPHA_GROUP2},
	{0x143,"divs/um",	ALPHA_GROUP2},
	{0x160,"addt/um",	ALPHA_GROUP2},
	{0x161,"subt/um",	ALPHA_GROUP2},
	{0x162,"mult/um",	ALPHA_GROUP2},
	{0x163,"divt/um",	ALPHA_GROUP2},
	{0x16c,"cvtts/um",	ALPHA_GROUP2},
	{0x16f,"cvttq/vm",	ALPHA_GROUP2},
	{0x180,"adds/u",	ALPHA_GROUP2},
	{0x181,"subs/u",	ALPHA_GROUP2},
	{0x182,"muls/u",	ALPHA_GROUP2},
	{0x183,"divs/u",	ALPHA_GROUP2},
	{0x1a0,"addt/u",	ALPHA_GROUP2},
	{0x1a1,"subt/u",	ALPHA_GROUP2},
	{0x1a2,"mult/u",	ALPHA_GROUP2},
	{0x1a3,"divt/u",	ALPHA_GROUP2},
	{0x1ac,"cvtts/u",	ALPHA_GROUP2},
	{0x1af,"cvttq/v",	ALPHA_GROUP2},
	{0x1c0,"adds/ud",	ALPHA_GROUP2},
	{0x1c1,"subs/ud",	ALPHA_GROUP2},
	{0x1c2,"muls/ud",	ALPHA_GROUP2},
	{0x1c3,"divs/ud",	ALPHA_GROUP2},
	{0x1e0,"addt/ud",	ALPHA_GROUP2},
	{0x1e1,"subt/ud",	ALPHA_GROUP2},
	{0x1e2,"mult/ud",	ALPHA_GROUP2},
	{0x1e3,"divt/ud",	ALPHA_GROUP2},
	{0x1ec,"cvtts/ud",	ALPHA_GROUP2},
	{0x1ef,"cvttq/vd",	ALPHA_GROUP2},
	{0x2ac,"cvtst",	ALPHA_GROUP2},
	{0x500,"adds/suc",	ALPHA_GROUP2},
	{0x501,"subs/suc",	ALPHA_GROUP2},
	{0x502,"muls/suc",	ALPHA_GROUP2},
	{0x503,"divs/suc",	ALPHA_GROUP2},
	{0x520,"addt/suc",	ALPHA_GROUP2},
	{0x521,"subt/suc",	ALPHA_GROUP2},
	{0x522,"mult/suc",	ALPHA_GROUP2},
	{0x523,"divt/suc",	ALPHA_GROUP2},
	{0x52c,"cvtts/suc",	ALPHA_GROUP2},
	{0x52f,"cvttq/svc",	ALPHA_GROUP2},
	{0x540,"adds/sum",	ALPHA_GROUP2},
	{0x541,"subs/sum",	ALPHA_GROUP2},
	{0x542,"muls/sum",	ALPHA_GROUP2},
	{0x543,"divs/sum",	ALPHA_GROUP2},
	{0x560,"addt/sum",	ALPHA_GROUP2},
	{0x561,"subt/sum",	ALPHA_GROUP2},
	{0x562,"mult/sum",	ALPHA_GROUP2},
	{0x563,"divt/sum",	ALPHA_GROUP2},
	{0x56c,"cvtts/sum",	ALPHA_GROUP2},
	{0x56f,"cvttq/svm",	ALPHA_GROUP2},
	{0x580,"adds/su",	ALPHA_GROUP2},
	{0x581,"subs/su",	ALPHA_GROUP2},
	{0x582,"muls/su",	ALPHA_GROUP2},
	{0x583,"divs/su",	ALPHA_GROUP2},
	{0x5a0,"addt/su",	ALPHA_GROUP2},
	{0x5a1,"subt/su",	ALPHA_GROUP2},
	{0x5a2,"mult/su",	ALPHA_GROUP2},
	{0x5a3,"divt/su",	ALPHA_GROUP2},
	{0x5a4,"cmptun/su",	ALPHA_GROUP2},
	{0x5a5,"cmpteq/su",	ALPHA_GROUP2},
	{0x5a6,"cmptlt/su",	ALPHA_GROUP2},
	{0x5a7,"cmptle/su",	ALPHA_GROUP2},
	{0x5ac,"cvtts/su",	ALPHA_GROUP2},
	{0x5af,"cvttq/sv",	ALPHA_GROUP2},
	{0x5c0,"adds/sud",	ALPHA_GROUP2},
	{0x5c1,"subs/sud",	ALPHA_GROUP2},
	{0x5c2,"muls/sud",	ALPHA_GROUP2},
	{0x5c3,"divs/sud",	ALPHA_GROUP2},
	{0x5e0,"addt/sud",	ALPHA_GROUP2},
	{0x5e1,"subt/sud",	ALPHA_GROUP2},
	{0x5e2,"mult/sud",	ALPHA_GROUP2},
	{0x5e3,"divt/sud",	ALPHA_GROUP2},
	{0x5ec,"cvtts/sud",	ALPHA_GROUP2},
	{0x5ef,"cvttq/svd",	ALPHA_GROUP2},
	{0x6ac,"cvtst/s",	ALPHA_GROUP2},
	{0x700,"adds/suic",	ALPHA_GROUP2},
	{0x701,"subs/suic",	ALPHA_GROUP2},
	{0x702,"muls/suic",	ALPHA_GROUP2},
	{0x703,"divs/suic",	ALPHA_GROUP2},
	{0x720,"addt/suic",	ALPHA_GROUP2},
	{0x721,"subt/suic",	ALPHA_GROUP2},
	{0x722,"mult/suic",	ALPHA_GROUP2},
	{0x723,"divt/suic",	ALPHA_GROUP2},
	{0x72c,"cvtts/suic",ALPHA_GROUP2},
	{0x72f,"cvttq/svic",ALPHA_GROUP2},
	{0x73c,"cvtqs/suic",ALPHA_GROUP2},
	{0x73e,"cvtqt/suic",ALPHA_GROUP2},
	{0x740,"adds/suim",	ALPHA_GROUP2},
	{0x741,"subs/suim",	ALPHA_GROUP2},
	{0x742,"muls/suim",	ALPHA_GROUP2},
	{0x743,"divs/suim",	ALPHA_GROUP2},
	{0x760,"addt/suim",	ALPHA_GROUP2},
	{0x761,"subt/suim",	ALPHA_GROUP2},
	{0x762,"mult/suim",	ALPHA_GROUP2},
	{0x763,"divt/suim",	ALPHA_GROUP2},
	{0x76c,"cvtts/suim",ALPHA_GROUP2},
	{0x76f,"cvttq/svim",ALPHA_GROUP2},
	{0x77c,"cvtqs/suim",ALPHA_GROUP2},
	{0x77e,"cvtqt/suim",ALPHA_GROUP2},
	{0x780,"adds/sui",	ALPHA_GROUP2},
	{0x781,"subs/sui",	ALPHA_GROUP2},
	{0x782,"muls/sui",	ALPHA_GROUP2},
	{0x783,"divs/sui",	ALPHA_GROUP2},
	{0x7a0,"addt/sui",	ALPHA_GROUP2},
	{0x7a1,"subt/sui",	ALPHA_GROUP2},
	{0x7a2,"mult/sui",	ALPHA_GROUP2},
	{0x7a3,"divt/sui",	ALPHA_GROUP2},
	{0x7ac,"cvtts/sui",	ALPHA_GROUP2},
	{0x7af,"cvttq/svi",	ALPHA_GROUP2},
	{0x7bc,"cvtqs/sui",	ALPHA_GROUP2},
	{0x7be,"cvtqt/sui",	ALPHA_GROUP2},
	{0x7c0,"adds/suid",	ALPHA_GROUP2},
	{0x7c1,"subs/suid",	ALPHA_GROUP2},
	{0x7c2,"muls/suid",	ALPHA_GROUP2},
	{0x7c3,"divs/suid",	ALPHA_GROUP2},
	{0x7e0,"addt/suid",	ALPHA_GROUP2},
	{0x7e1,"subt/suid",	ALPHA_GROUP2},
	{0x7e2,"mult/suid",	ALPHA_GROUP2},
	{0x7e3,"divt/suid",	ALPHA_GROUP2},
	{0x7ec,"cvtts/suid",ALPHA_GROUP2},
	{0x7ef,"cvttq/svid",ALPHA_GROUP2},
	{0x7fc,"cvtqs/suid",ALPHA_GROUP2},
	{0x7fe,"cvtqt/suid",ALPHA_GROUP2},
	{0xfff,"",		ALPHA_ERROR}
};

/* table17 */
alpha_opcode_tab_entry alpha_instr_tbl_ext17[] =
{    
	{0x000,"",		ALPHA_ERROR},
	{0x010,"cvtlq",	ALPHA_GROUP2},
	{0x020,"cpys",		ALPHA_GROUP2},
	{0x021,"cpysn",	ALPHA_GROUP2},
	{0x022,"cpyse",	ALPHA_GROUP2},
	{0x024,"mt_fpcr",	ALPHA_GROUP2},
	{0x025,"mf_fpcr",	ALPHA_GROUP2},
	{0x02a,"fcmoveq",	ALPHA_GROUP2},
	{0x02b,"fcmovne",	ALPHA_GROUP2},
	{0x02c,"fcmovlt",	ALPHA_GROUP2},
	{0x02d,"fcmovge",	ALPHA_GROUP2},
	{0x02e,"fcmovle",	ALPHA_GROUP2},
	{0x02f,"fcmovgt",	ALPHA_GROUP2},
	{0x030,"cvtql",	ALPHA_GROUP2},
	{0x130,"cvtql/v",	ALPHA_GROUP2},
	{0x530,"cvtql/sv",	ALPHA_GROUP2},
	{0xfff,"",		ALPHA_ERROR}
};
    
/* table18 */
alpha_opcode_tab_entry alpha_instr_tbl_ext18[] =
{
	{0x0000,"trapb",	ALPHA_GROUP3},
	{0x0400,"excb",	ALPHA_GROUP3},
	{0x4000,"mb",		ALPHA_GROUP3},
	{0x4400,"wmb",		ALPHA_GROUP3},
	{0x8000,"fetch",	ALPHA_GROUP3},
	{0xa000,"fetch_m",	ALPHA_GROUP3},
	{0xc000,"rpcc",	ALPHA_GROUP3},
	{0xe000,"rc",		ALPHA_ERROR},
	{0xe800,"ecb",		ALPHA_ERROR},
	{0xf000,"rs",		ALPHA_ERROR},
	{0xf800,"wh64",	ALPHA_ERROR},
	{0xffff,"",		ALPHA_ERROR}
};

/* table1a */
alpha_opcode_tab_entry alpha_instr_tbl_ext1a[] =
{    
	{0x0,"jmp",		ALPHA_GROUP_JMP},
	{0x1,"jsr",		ALPHA_GROUP_JMP},
	{0x2,"ret",		ALPHA_GROUP_JMP},
	{0x3,"jsr_co",		ALPHA_GROUP_JMP},
	{0xf,"",			ALPHA_ERROR}
};

/* table1c */
alpha_opcode_tab_entry alpha_instr_tbl_ext1c[] =
{
	{0x00,"sextb",		ALPHA_GROUP1},
	{0x01,"sextw",		ALPHA_GROUP1},
	{0x30,"ctpop",		ALPHA_GROUP1},
	{0x31,"perr",		ALPHA_GROUP1},
	{0x32,"ctlz",		ALPHA_GROUP1},
	{0x33,"cttz",		ALPHA_GROUP1},
	{0x34,"unpkbw",	ALPHA_GROUP1},
	{0x35,"unpkbl",	ALPHA_GROUP1},
	{0x36,"pkwb",		ALPHA_GROUP1},
	{0x37,"pklb",		ALPHA_GROUP1},
	{0x38,"minsb8",	ALPHA_GROUP1},
	{0x39,"minsw4",	ALPHA_GROUP1},
	{0x3a,"minub8",	ALPHA_GROUP1},
	{0x3b,"minuw4",	ALPHA_GROUP1},
	{0x3c,"maxub8",	ALPHA_GROUP1},
	{0x3d,"maxuw4",	ALPHA_GROUP1},
	{0x3e,"maxsb8",	ALPHA_GROUP1},
	{0x3f,"maxsw4",	ALPHA_GROUP1},
	{0x70,"ftoit",		ALPHA_GROUP_F2I},
	{0x78,"ftois",		ALPHA_GROUP_F2I},
	{0xff,"",			ALPHA_ERROR}
};

