///////
   //    MySQL Database class for ht://Check
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmysqlDB.h,v 1.24 2004/03/30 11:08:59 angusgb Exp $
   //
   //    Started: 28.06.1999
///////

#ifndef _HTMYSQLDB_H
#define _HTMYSQLDB_H

#include "Htmysql.h"
#include "htString.h"
#include "_Server.h"
#include "_Url.h"
#include "HtCookie.h"
#include "SchedulerEntry.h"
#include "HtmlStatement.h"
#include "HtmlAttribute.h"
#include "Link.h"
#include "RunInfo.h"
#include "Dictionary.h"
#include "AccessibilityCheck.h"
   
class HtmysqlDB : public Htmysql
{

///////
   //    Public Interface
///////

   public:

//      HtmysqlDB(const String &host, const String &db,
//         const String &user, const String &passwd);

///////
   //    
///////

      HtmysqlDB(const String &db, const String &File, String Group,
         int *argc, char ***argv);

      virtual ~HtmysqlDB();


///////
   //    Set methods for protected attributes
///////
      
      // Set the length for the Index regarding
      // the Url field in the Schedule and Url tables
      // This method is publicly accessible
      void SetURL_Index_Length(const int &i) { URL_Index_Length = i; }

///////
   //    Access methods to protected attributes
///////
      
      const String &GetHost() {return MySQLHost;}
      const String &GetDB() {return MySQLDB;}
      const String &GetUser() {return MySQLUser;}
      const String &GetDBSignature() {return DBSignature;}
      const int GetURL_Index_Length() {return URL_Index_Length;}


///////
   //    Connection to the MySQL database server
///////
      
      virtual int Connect(); // Let's connect with it
      
///////
   //    ht://Check Database creation -- with a MySQL query script
///////
      
      virtual int CreateDatabase();


///////
   //    ht://Check Database drop -- with a MySQL query script
///////
      
      virtual int DropDatabase();
      virtual int DropTables(); // Keep the database, but recreate ht://Check tables only


///////
   //    Function to insert an object of various type
///////

      int Insert (SchedulerEntry&);    // Insert a scheduler entry
                                        // into Schedule table and
                                        // updates its ID
                                       
      int Insert (const _Server&);          // Insert a record into Server table       
      int Insert (const _Url&);             // Insert a record into Url table       
      int Insert (const HtmlStatement&);    // Insert a record into
                                       // HtmlStatement table       
      int Insert (const HtmlAttribute&);    // Insert a record into
                                       // HtmlAttribute table       
      int Insert (const Link&);             // Insert a record into Link table       
      int Insert (const RunInfo&);          // Insert general info into the db
      int Insert (const HtCookie&);   // Insert a record into Cookie table       
      int Insert (const AccessibilityCheck&);    // Insert a record into
                                       // AccessibilityCheck table       
      
      // Insert a link description into the HtmlStatement
      int InsertHtmlStatementLinkDescription(const unsigned int IDUrl,
		          const unsigned int TagPosition, const String& LinkDescription);

///////
   //    Search functions, given a filter and a HtmysqlQueryResult
///////

      // Look for a scheduler entry
      int Search (SchedulerEntry &filter, HtmysqlQueryResult &result);
//      int Search (_Server &filter, HtmysqlQueryResult &result);


///////
   //    Query execution and storing method
   //    If an error occurs, -1 is returned
   //    If result is specified, we store the result of the query and
   //    the function returns the number of rows found, else 0.
///////

      int Query(String &SQLStatement, HtmysqlQueryResult *result = 0,
         Query_Type qt = Htmysql_Stored);


///////
   //    Create a SQL string for a filter (Where clause)
///////

      void CreateFilter(String &SQLStatement, SchedulerEntry &filter);
//      void CreateFilter(String &SQLStatement, _Server &filter);
      

///////
   //    Get next element from a result of a query, given a HtmysqlQueryResult
   //    and a storing object (for example, a SchedulerEntry, a _Url, ...)
   //    Returns 0 if the end of the query has been reached.
///////

      int GetNextElement (SchedulerEntry &dest, HtmysqlQueryResult &result);
//      int GetNextElement (_Server &dest, HtmysqlQueryResult &result);


///////
   //    Manage the table with anchors and the link table
///////

   int AnchorsTable(ostream& output = std::cout);
   int CreateAnchorsTable();
   int SetAnchorsResults(Link &LinkTmp);
   

///////
   //    Create the indexes for the link table only at the end
   //    because they are not useful before. This can save a lot
   //    of time due to continous updates of indexes when a new
   //    entry for the link table is added.
///////

   int CreateLinkTableIndexes();



 ///////
    //    Set the Link results (at the end of the crawl)
    //    Look for all the links that have 'NotChecked' flag in the LinkResult
    //    field. For each of them, it checks all of the links, and see if
    //    they are eithrt found or not retrieved or broken or redirected.
    //    Then it updates the Link table with the right flag.
    //    Now the BadEncoded case is treated as well.
 ///////

   int SetLinkResults(ostream& output = std::cout);


///////
   //    Set the SQL BIG TABLES option
   //    Return 0 if fails
///////

      virtual int SetSQLBigTableOption();

///////
   //    Optimizie the database
///////

      virtual int Optimize();

///////      
   //    Set the list of available charsets
///////      
      void LoadAvailableCharsets(const String& c);

///////
   //    Public Attributes
///////
   
   protected:
   
      String   MySQLHost;     // Host running a MySQL daemon
      String   MySQLDB;       // Database to be connected with

      String   MySQLUser;     // Authentication information - User
      String   MySQLPasswd;   // and password
      int      MySQLPort;     // Port number
      String   MySQLSocket;   // Socket name

      // This variable holds the length of the URL Index
      // in the URL and Schedule tables   
      int      URL_Index_Length;

      String   DBSignature;   // Signature of the DB (db@host);

      Dictionary AvailableCharsets;  // list of available charsets
      
      void LoadDefaults(const String &File,
         MYSQL_LOAD_DEFAULTS_ARGTWO Group, int *argc, char ***argv);

      void AppendSQLTextField(String &Dest, const char *source);
   
};

#endif
