/*
//
// textfile.h
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#ifndef TEXTFILE_H
#define TEXTFILE_H

/*
// text file function
*/
typedef struct tagFILEINFO
{
    char            *name;
    char            *filename;
    FILE            *file;
    uint            lineNumber;
    uint            bytesReadThisLine;
    uint            bytesWrittenThisLine;
    WORD            flags;
} TEXTFILE;

/*
// TEXTFILE flags
*/
#define TEXTFILE_FLAG_NONE          (0)
#define TEXTFILE_FLAG_NULL_FILE     (0x0001)
#define TEXTFILE_FLAG_NO_CR         (0x0002)

/*
// text file functions
*/
BOOL OpenFile(const char *name, const char *filename, const char *openFlags,
    TEXTFILE *textFile);
void CloseFile(TEXTFILE *textFile);

void CreateNullFile(TEXTFILE *textFile);

void SuppressLinefeeds(TEXTFILE *textFile);
void AllowLinefeeds(TEXTFILE *textFile);

BOOL GetFileChar(TEXTFILE *textFile, char *ch);
BOOL PutFileChar(TEXTFILE *textFile, char ch);

#ifdef DUMB_TEXTFILE_PROTOTYPE
BOOL PutFileString();
#else
BOOL PutFileString(TEXTFILE *textFile, const char *format, ...);
#endif

BOOL GetFileLine(TEXTFILE *textfile, char *buffer, uint size);

#endif

