---
title: i18n
linktitle: i18n
description: Translates a piece of content based on your i18n configuration files.
date: 2017-02-01
publishdate: 2017-02-01
lastmod: 2017-02-01
categories: [functions]
menu:
  docs:
    parent: "functions"
keywords: [internationalization,i18n,multilingual]
signature: ["i18n KEY", "T KEY"]
workson: []
hugoversion:
relatedfuncs: []
deprecated: false
aliases: []
---

This translates a piece of content based on your `i18n/en-US.toml` files. You can use the [go-i18n](https://github.com/nicksnyder/go-i18n) tools to manage your translations. The translations can exist in both the theme and at the root of your repository.

```
{{ i18n "translation_id" }}
```

{{% note "Alias `T`" %}}
`T` is an alias to `i18n`. E.g. `{{ T "translation_id" }}`.
{{% /note %}}

### Query a flexible translation with variables

Often you will want to use the page variables in the translation strings. To do so, pass the `.` context when calling `i18n`:

```
{{ i18n "wordCount" . }}
```

The function will pass the `.` context to the `"wordCount"` id:

{{< code-toggle file="i18n/en-US" >}}
[wordCount]
other = "This article has {{ .WordCount }} words."
{{< /code-toggle >}}

Assume `.WordCount` in the context has value is 101. The result will be:

```
This article has 101 words.
```

For more information about string translations, see [Translation of Strings in Multilingual Mode][multistrings].

[multistrings]: /content-management/multilingual/#translation-of-strings
