<?php
// File           database.php / ibWebAdmin
// Purpose        do all the tasks concerning databases
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        Thu Aug 31 14:12:47 CEST 2000
//
// $Id: database.php,v 1.33 2004/02/04 17:43:15 lbrueckner Exp $

require('./inc/script_start.inc.php');

//
// script is called from login form
//
if (isset($HTTP_POST_VARS['db_login_doit'])){
    // close existing connection, if any
    if (!empty($dbhandle)) {
        ibase_close($dbhandle);
    }
    $s_login['database'] = $HTTP_POST_VARS['db_login_database'];
    $s_login['user']     = strtoupper($HTTP_POST_VARS['db_login_user']);
    $s_login['host']     = $HTTP_POST_VARS['db_login_host'];

    // don't set s_login['password'] if it contains only stars
    // (from function password_stars())
    $pw = $HTTP_POST_VARS['db_login_password'];
    if (strspn($pw, '*') != strlen($pw)) {
    	$s_login['password'] = $pw;
    }

    $s_login['role']   = !empty($HTTP_POST_VARS['db_login_role'])  ? $HTTP_POST_VARS['db_login_role']  : '';
    $s_login['cache']  = !empty($HTTP_POST_VARS['db_login_cache']) ? $HTTP_POST_VARS['db_login_cache'] : '';
    if ($s_login['cache'] != NULL  &&  $s_login['cache'] < 10) {
        $s_login['cache'] = 10;
    }
    $s_login['charset'] = !empty($HTTP_POST_VARS['db_login_charset']) ? $HTTP_POST_VARS['db_login_charset'] : '';
    $s_login['dialect'] = !empty($HTTP_POST_VARS['db_login_dialect']) ? $HTTP_POST_VARS['db_login_dialect'] : '';
    $s_login['server']  = !empty($HTTP_POST_VARS['db_login_server'])  ? $HTTP_POST_VARS['db_login_server']  : '';
    
    if ($s_login['database'] == '') {
        $error = $ERRORS['NO_DB_SELECTED'];
    }
    elseif (!have_db_suffix($s_login['database'])) {
        $error = sprintf($ERRORS['WRONG_DB_SUFFIX'], "'".implode("', '", $DATABASE_SUFFIXES)."'");
    }
    elseif (!is_allowed_db($s_login['database'])) {
        $error = sprintf($ERRORS['DB_NOT_ALLOWED'], $s_login['database']);
    }

    if (empty($error)) {
        if ($dbhandle = db_connect()) {

            // connected successfully  
            $s_connected = TRUE;

            remove_edit_panels();
            $s_charsets = get_charsets(SERVER_FAMILY, SERVER_VERSION);
        } else {
            // connect failed 
            $ib_error = ibase_errmsg();
            $s_login['password'] = '';
            $s_connected = FALSE;
        }
    }
    cleanup_session();
}


//
// the Logout-Button from the login-panel 
//
if (isset($HTTP_POST_VARS['db_logout_doit'])){

    if (!empty($dbhandle)) {
        ibase_close($dbhandle);
    }
    remove_edit_panels();
    cleanup_session();
    $s_login['password'] = '';

    $s_connected = FALSE;
}


//
// script is called from create database form
//
if (isset($HTTP_POST_VARS['db_create_doit'])
&&  isset($HTTP_POST_VARS['db_create_database'])
&&  !empty($HTTP_POST_VARS['db_create_database'])) {

    $s_create_db   = trim($HTTP_POST_VARS['db_create_database']);
    $s_create_host = trim($HTTP_POST_VARS['db_create_host']);
    $s_create_user = trim($HTTP_POST_VARS['db_create_user']);

    // dont set $s_create_pw if it contains only starts 
    // (from function password_stars() )
    $pw = $HTTP_POST_VARS['db_create_password'];
    if (strspn($pw, '*') != strlen($pw))
        $s_create_pw = $pw;
    $s_create_pagesize = $HTTP_POST_VARS['db_create_pagesize'];
    $s_create_charset = $HTTP_POST_VARS['db_create_charset'];


    if (!have_db_suffix($s_create_db)) {
        $error = sprintf($ERRORS['WRONG_DB_SUFFIX'], "'".implode("', '", $DATABASE_SUFFIXES)."'");
    }
    elseif (!is_allowed_db($s_create_db)) {
        $error = sprintf($ERRORS['DB_NOT_ALLOWED'], $s_create_db);
    }

    // close existing connection, if any
    if (!empty($dbhandle)  &&  empty($error)) {
        ibase_close($dbhandle);
    }

    // build a sql statement from the values
    // we received from the db_create_form
    if (empty($error)) {

        $db_str = (!empty($s_create_host)) ? $s_create_host.':'.$s_create_db : $s_create_db;

        $sql = 'CREATE DATABASE "'.$db_str.'"';
        if (strlen($s_create_user) > 0) {
            $sql .= ' USER "'.$s_create_user.'"';
            if (strlen($s_create_pw) > 0)
                $sql .= ' PASSWORD "'.$s_create_pw.'"';
        }
        if ($s_create_pagesize != 1024) {
            // 1024 is the default page size
            $sql .= ' PAGE_SIZE = '.$s_create_pagesize;
        }

        if ($s_create_charset != 'NONE') {
            // NONE is the default character set
            $sql .= ' DEFAULT CHARACTER SET '.$s_create_charset;
        }

        $sql .= ';';
        list($binary_output, $binary_error) = isql_execute($sql);

        if (empty($binary_error)  &&  !is_file($s_create_db)) {
            $error = sprintf($ERRORS['CREATE_DB_FAILED'], $s_create_db);

        } else { // connect the new created database

            $s_login['charset']  = $s_create_charset;
            $s_login['database'] = $s_create_db;
            $s_login['host']     = $s_create_host;
            $s_login['user']     = strtoupper($s_create_user);
            $s_login['password'] = $s_create_pw;
            if ($dbhandle = db_connect()) {
                $s_connected = TRUE;
                remove_edit_panels();
                cleanup_session();
                $message = sprintf($MESSAGES['CREATE_DB_SUCCESS'], $s_create_db);
            } else {
                $ib_error = ibase_errmsg();
            }
        }
    }
}

//
// script is called from delete database form
//
if (isset($HTTP_POST_VARS['db_delete_doit'])
&&  isset($HTTP_POST_VARS['db_delete_database'])
&&  !empty($HTTP_POST_VARS['db_delete_database'])) {

    $s_delete_db   = $HTTP_POST_VARS['db_delete_database'];
    $s_delete_user = $HTTP_POST_VARS['db_delete_user'];
    $s_delete_host = $HTTP_POST_VARS['db_delete_host'];

    // don't set $s_delete_pw if it contains only starts 
    // (from function password_stars())
    $pw = $HTTP_POST_VARS['db_delete_password'];
    if (strspn($pw, '*') != strlen($pw))
        $s_delete_pw = $pw;

    // cannot delete the current database
    if ($s_login['database'] == $s_delete_db) {
        $message = sprintf($MESSAGES['DELETE_CON_DB'], $s_delete_db);
        $s_login['database'] = '';
	$s_connected = FALSE;
        remove_edit_panels();
        cleanup_session();
    }

    elseif (!have_db_suffix($s_delete_db)) {
        $error = sprintf($ERRORS['WRONG_DB_SUFFIX'], implode("', '", "'".$DATABASE_SUFFIXES)."'");
    }
    elseif (!is_allowed_db($s_delete_db)) {
        $error = sprintf($ERRORS['DB_NOT_ALLOWED'], $s_delete_db);
    }

    else {
        $sql =  "DROP DATABASE;\n";

        if ($s_cust['askdel'] == TRUE) {
            $s_confirmations['database'] = 
                 array('msg' => sprintf($MESSAGES['CONFIRM_DB_DELETE'], $s_delete_db),
                       'sql' => $sql);
        }
        else {
            list($binary_output, $binary_error) = isql_execute($sql, 
                                                               $s_delete_user,
                                                               $s_delete_pw,
                                                               $s_delete_db,
                                                               $s_delete_host);
            $s_delete_db = '';
        }
    }
}

// deleting a database is confirmed
if (isset($HTTP_POST_VARS['confirm_yes'])) {
    list($binary_output, $binary_error) = isql_execute($s_confirmations['database']['sql'],
                                                       $s_delete_user,
                                                       $s_delete_pw,
                                                       $s_delete_db,
                                                       $s_delete_host);
    unset($s_confirmations['database']);
    $s_delete_db = '';
}

// deleting a database is canceled
if (isset($HTTP_POST_VARS['confirm_no'])) {
    unset($s_confirmations['database']);
    $s_delete_db = '';
}


//
// get the data for the metadata panel
//
$idx = get_panel_index($s_database_panels, 'db_meta');
if ($s_database_panels[$idx][2] == 'open'  &&  $s_connected) {

    list($metadata, $binary_error) = isql_get_metadata($s_login['user'], $s_login['password'], $s_login['database'], $s_login['host']);

    //
    // Save to File on the Metadata panel was selected
    //
    if (isset($HTTP_POST_VARS['db_meta_save'])) {
        if (empty($binary_error)  &&  count($metadata) > 0) {

            send_export_headers('application/octet-stream', 'meta.sql');          
            print (implode("\n", $metadata));
            exit();
        }
    }
}


//
// something happened on the System Tables panel
// 
if (isset($HTTP_POST_VARS['db_systable_select'])) {

    if ($s_systable['table'] != $HTTP_POST_VARS['db_systable']) {
        $s_systable['order']  = '';
        $s_systable['dir']    = 'ASC';
    }

    $s_systable['table']  = $HTTP_POST_VARS['db_systable'];
    $s_systable['ffield'] = $HTTP_POST_VARS['db_sysfield'];
    $s_systable['fvalue'] = $HTTP_POST_VARS['db_sysvalue'];

    $s_systable['sysdata'] = (isset($HTTP_POST_VARS['db_sysdata']) ? TRUE : FALSE);
}

if (isset($HTTP_GET_VARS['order'])) {

    $s_systable['dir'] = ($HTTP_GET_VARS['order'] == $s_systable['order']  &&  $s_systable['dir'] == 'ASC')
        ? 'DESC'
        : 'ASC';
    $s_systable['order'] = $HTTP_GET_VARS['order'];
}

// determine the informations for the selected system table
$idx = get_panel_index($s_database_panels, 'db_systable');
if ($s_database_panels[$idx][2] == 'open') {

    // include the javascript for jsrs requests
    if ($s_use_jsrs == TRUE) {
        $js_stack .= js_jsrs_filter_fields();
    }

    if ($s_use_jsrs == TRUE  &&  strpos($s_systable['table'], 'TMP$') === 0) {
        $have_refresh =  TRUE;
        $js_stack .= js_jsrs_refresh_systable();
    }
    else {
        $have_refresh = FALSE;
    }

    if ($s_connected   &&  !empty($s_systable['table'])) {

        // include the javascript for marking table rows
        $js_stack .= js_selectableelements()
                    .js_selectabletablerows_listener('systable');

        include ('inc/system_table.inc.php');
        $systable = get_systable($s_systable);
    }
}


//
// determine the accessible databases for the login panel
//
$dbfiles = array();
if (isset($ALLOWED_FILES)  && count($ALLOWED_FILES) > 0) {
    foreach ($ALLOWED_FILES AS $file) {
        if (is_file($file)  &&  have_db_suffix($file)) {
            $dbfiles[] = $file;
        }
    }
}
elseif (isset($ALLOWED_DIRS)  &&  count($ALLOWED_DIRS) > 0) {
    foreach ($ALLOWED_DIRS as $dir) {
        if (!@is_readable($dir)) {
            $warning .=sprintf($WARNINGS['CAN_NOT_ACCESS_DIR'], $dir);
        }
        else {
            $dirhandle = opendir($dir);
            while ($filename = readdir($dirhandle)){
                if (have_db_suffix($filename)) {
                    $dbfiles[] = $dir.$filename;            
                }
            }
            closedir($dirhandle);
        }
    }
}
sort($dbfiles);


//
// print out all the panels
//
$active = 'Database';
$panels = &$s_database_panels;

require('./inc/script_end.inc.php');

?>
