<?php
// File           jsrs/closed_panel_request.php / ibWebAdmin
// Purpose        mark a panel as closed in the session and deliver the html for
//                the closed panel
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <03/02/10 22:21:44 lb>
//
// $IdK$: fk_request.php,v 1.3 2003/02/02 20:16:41 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');

session_start();
localize_session_vars();

require('../lang/' . (isset($s_cust) ? $s_cust['language'] : LANGUAGE) . '.inc.php');
require('../inc/functions.inc.php');
require('../inc/array_functions.inc.php');
require('../inc/panel_elements.inc.php');
require('./jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

// answer to the request with the result of get_fk_values()
jsrsDispatch('closed_panel');


// build the answer for the jsrs request
function closed_panel($idx, $active){

    //calculate the panel name
    $pvar = 's_'.strtolower($active).'_panels';

    $GLOBALS[$pvar][$idx][2] = 'close';

    $icon = DATAPATH . (BG_TRANSPARENT == TRUE ? 'transparent/' : 'opaque/') . strtolower(ICON_SIZE) . '/' . 'open.png';
    $html = get_closed_panel($GLOBALS[$pvar][$idx][1], $active, $idx, $icon);

    // work around for a Mozilla bug 
    if ($GLOBALS['s_useragent']['ns6up'] == TRUE) {
        $html = str_replace('&amp;', '&', $html);
    }

    set_customize_cookie($GLOBALS['s_cust']);

    globalize_session_vars();

    return jsrsArrayToString(array($idx, $html), $delim='~');
}

?>
