<?php
// File           open_panel.php / ibWebAdmin
// Purpose        html sequence for an opened panel
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/09/08 13:54:00 lb>
//
// $Id: open_panel.php,v 1.11 2004/02/07 15:18:19 lbrueckner Exp $


// Variables      $panel[0]   panel name
//                $panel[1]   panel title
//                $active     active menu item
//                $nr         index of the panel in $s_xyz_panels[]


$fold_url = ($s_use_jsrs == TRUE)
          ? sprintf("javascript:requestClosedPanel('%d', '%s')", $nr, $active)
          : url_session("toggle_fold_panel.php?a=$active&p=$nr&d=close");

?>
<table width="100%" class="area" cellpadding="5" cellspacing="0" border="0">
  <tr class="panel">
    <td rowspan="2" width="25" align="center" valign="top">
      <?php printf('<a href="%1$s"><img src="%2$s" alt="%3$s" title="%3$s" border="0"></a>'."\n", $fold_url, $close_icon, $ptitle_strings['Close']); ?>
    </td>
    <td width="100%"><b><?php echo $panel[1]; ?></b></td>
    <td>
<?php panel_navigation($active, $nr); ?>
    </td>                                               
  </tr>
  <tr>
     <td colspan="2">
<?php

// there may be different instances of the data edit/delete panel,
// which carrying the instance nr in the panel name
if (preg_match('/dt_(edit|delete)([0-9]+)/', $panel[0], $matches)) {
    $instance = $matches[2];
    if ($matches[1] == 'edit') {
        include('./panels/dt_edit.php');
    }
    else {
        $subject = 'row';
        include('./panels/confirm.php');
    }
}
else {
    include('./panels/'.$panel[0].'.php');
}

?>
     </td>
  </tr>
</table>
