/* ice_resolv.h
 * - General Resolving Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_RESOLV_H
#define __ICECAST_RESOLV_H

#include "icetypes.h"

#ifndef _WIN32
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#endif

#define SOCK_BLOCK 0
#define SOCK_NONBLOCK 1

/* Resolv functions */
struct hostent *ice_gethostbyname (const char *hostname, struct hostent *res, char *buffer, int buflen, int *error);
struct hostent *ice_gethostbyaddr (const char *host, int hostlen, struct hostent *he, char *buffer, int buflen, int *error);
void ice_clean_hostent();
char *reverse (const char *hostname);
char *forward (const char *name, char *buf);

struct hostent *standard_gethostbyname(const char *hostname, struct hostent *res, char *buffer, int buflen, int *error);
struct hostent *standard_gethostbyaddr(const char *host, int hostlen, struct hostent *he, char *buffer, int buflen, int *error);

#ifdef SOLARIS_RESOLV_OK
struct hostent *solaris_gethostbyname_r (const char *hostname, struct hostent *res, char *buffer, int buflen, int *error);
struct hostent *solaris_gethostbyaddr_r (const char *host, int hostlen, struct hostent *he, char *buffer, int buflen, int *error);
#endif

#ifdef LINUX_RESOLV_OK
struct hostent *
linux_gethostbyname_r (const char *hostname, struct hostent *res, char *buffer, int buflen, int *error);
struct hostent *linux_gethostbyaddr_r (const char *host, int hostlen, struct hostent *he, char *buffer, int buflen, int *error);
#endif

#endif

