/* writeico.c
 * 
 * Copyright (C) 1998-2001  Oskar Liljeblad
 *
 * This file is part of icoutils.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file "LICENSE" for
 * details.
 */

#include "icotool.h"

#ifdef HAVE_BYTESWAP_H
#include <byteswap.h>
#endif
#include <stdio.h>

#include "win32-endian.h"

void
write_ico_file(int image_count)
{
    int c;
    uint32_t offset;
    Win32CursorIconFileDir ci_dir;
    FILE *out = stdout;

    ci_dir.reserved = 0;
    ci_dir.type = (resource_type == RESOURCE_CURSOR ? 2 : 1);
    ci_dir.count = image_count;
    offset = sizeof(Win32CursorIconFileDir);
    fix_win32_cursor_icon_file_dir_endian(&ci_dir);
    fwrite(&ci_dir, offset, 1, out);

    /* PLAN:
     * for each command line argument, 
     *   read from image file (format ppm, xpm) to an IcoToolIcon?
     * 
     */

    offset += image_count * sizeof(Win32CursorIconFileDirEntry);
    for (c = 0; c < image_count; c++) {
    	Win32CursorIconFileDirEntry entry;
    	int bit_count;
	
	bit_count = ilog2l(image_color_count);
	entry.width = image_width;
	entry.height = image_height;
	entry.color_count = image_color_count;
	entry.reserved = 0;
#ifdef WORDS_BIGENDIAN
	entry.hotspot_x = bswap_16(cursor_hotspot_x);
	entry.hotspot_y = bswap_16(cursor_hotspot_y);
#else
	entry.hotspot_x = cursor_hotspot_x;
	entry.hotspot_y = cursor_hotspot_y;
#endif
	entry.dib_size = (resource_type == RESOURCE_CURSOR ? sizeof(uint16_t)*2 : 0)
		  + sizeof(Win32BitmapInfoHeader)
		  + sizeof(Win32RGBQuad) * image_color_count
		  + LINE_SIZE(image_width) * image_height
		  + LINE_SIZE(image_width * bit_count) * image_height;
    	entry.dib_offset = offset;
	offset += entry.dib_size;



    	fix_win32_cursor_icon_file_dir_entry_endian(&entry);
    	fwrite(&entry, sizeof(Win32CursorIconFileDirEntry), 1, out);
    }

    for (c = 0; c < image_count; c++) {
    	Win32BitmapInfoHeader bitmap;

    	bitmap.size = sizeof(Win32BitmapInfoHeader);
	bitmap.width = image_width;
	bitmap.height = image_height;
	//bitmap.planes =
	bitmap.bit_count = ilog2l(image_color_count);
	bitmap.compression = 0;
	//bitmap.size_image = 
	bitmap.x_pels_per_meter = 0;	    	    // FIXME default value
    	bitmap.y_pels_per_meter = 0;	    	    // FIXME default value
	bitmap.clr_used = image_color_count;
	bitmap.clr_important = 0;   	    	    // FIXME default value
	fix_win32_bitmap_info_header_endian(&bitmap);
	fwrite(&bitmap, bitmap.size, 1, out);

//FIXME
/*	fwrite(&rgb_data, sizeof(Win32RGBQuad) * color_count, 1, out);
    	fwrite(&image_data, image_line_width * height, 1, out);
	fwrite(&mask_data, mask_line_width * height, 1, out);*/
    }
}
